/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.translations;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import net.skinsrestorer.shadow.cloud.translations.LocaleExtractor;
import net.skinsrestorer.shadow.cloud.translations.ResourceBundleTranslatedCaptionProvider;
import net.skinsrestorer.shadow.cloud.translations.TranslatedCaptionProvider;
import net.skinsrestorer.shadow.cloud.translations.TranslationBundle;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.version.Stub;

@API(status=API.Status.INTERNAL)
@NestMembers(value={Control.class})
final class ResourceBundleTranslationBundle<C>
implements TranslationBundle<C> {
    private final String key;
    private final LocaleExtractor<C> localeExtractor;
    private final ClassLoader classLoader;
    private final Map<Locale, TranslatedCaptionProvider<C>> translations = new HashMap<Locale, TranslatedCaptionProvider<C>>();

    ResourceBundleTranslationBundle(@NonNull String baseName, @NonNull LocaleExtractor<C> localeExtractor, @NonNull ClassLoader classLoader) {
        this.key = Objects.requireNonNull(baseName, "baseName");
        this.localeExtractor = Objects.requireNonNull(localeExtractor, "localeExtractor");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
    }

    @Override
    public @NonNull LocaleExtractor<C> localeExtractor() {
        return this.localeExtractor;
    }

    @Override
    public synchronized @Nullable TranslatedCaptionProvider<C> translations(@NonNull Locale locale) {
        TranslatedCaptionProvider translatedCaptionProvider = this.translations.computeIfAbsent(locale, this::loadTranslations);
        if (translatedCaptionProvider.isEmpty()) {
            return null;
        }
        return translatedCaptionProvider;
    }

    private @NonNull TranslatedCaptionProvider<C> loadTranslations(@NonNull Locale locale) {
        try {
            return new ResourceBundleTranslatedCaptionProvider(ResourceBundle.getBundle(this.key, locale, this.classLoader, new Control()), locale);
        }
        catch (MissingResourceException ignored) {
            return TranslatedCaptionProvider.empty();
        }
    }

    public String jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$get$key() {
        return this.key;
    }

    public void jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$set$key(String string) {
        this.key = string;
    }

    public ClassLoader jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$get$classLoader() {
        return this.classLoader;
    }

    public void jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$set$classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @NestHost(value=ResourceBundleTranslationBundle.class)
    private final class Control
    extends ResourceBundle.Control {
        private final List<String> availableLocales;

        Control() {
            CharSequence[] split = ResourceBundleTranslationBundle.this.jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$get$key().replace(".", "/").split("/");
            String last = split[split.length - 1];
            split[split.length - 1] = Control.jvmdowngrader$concat$$init$$1(last);
            String path = String.join((CharSequence)"/", split);
            @Nullable URL url = ResourceBundleTranslationBundle.this.jvmdowngrader$nest$net_skinsrestorer_shadow_cloud_translations_ResourceBundleTranslationBundle$get$classLoader().getResource(path);
            if (url == null) {
                this.availableLocales = J_U_List.of();
                return;
            }
            try {
                URLConnection conn = url.openConnection();
                try (InputStream s = conn.getInputStream();){
                    this.availableLocales = J_U_S_Stream.toList(new BufferedReader(new InputStreamReader(new BufferedInputStream(s))).lines());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(Control.jvmdowngrader$concat$$init$$2(path), e);
            }
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> originalCandidates = super.getCandidateLocales(baseName, locale);
            if (this.availableLocales.isEmpty()) {
                return originalCandidates;
            }
            String base = null;
            int noCountry = -1;
            for (int i = 0; i < originalCandidates.size(); ++i) {
                Locale candidate = originalCandidates.get(i);
                if (Control.jvmdg$inlined$isBlank(candidate.getCountry())) {
                    base = candidate.getLanguage();
                    noCountry = i + 1;
                    break;
                }
                if (candidate != Locale.ROOT) continue;
                return originalCandidates;
            }
            ArrayList<Locale> locales = new ArrayList<Locale>(originalCandidates);
            if (base != null) {
                for (String localeString : this.availableLocales) {
                    if (!localeString.startsWith(Control.jvmdowngrader$concat$getCandidateLocales$1(base))) continue;
                    String[] split = localeString.split("_");
                    locales.add(noCountry, new Locale(split[0], split[1]));
                }
            }
            return new ArrayList<Locale>(new LinkedHashSet<Locale>(locales));
        }

        private static String jvmdowngrader$concat$$init$$1(String string) {
            return string + "-locales.list";
        }

        private static String jvmdowngrader$concat$$init$$2(String string) {
            return "Exception reading " + string;
        }

        private static String jvmdowngrader$concat$getCandidateLocales$1(String string) {
            return string + "_";
        }

        @Stub
        private static boolean jvmdg$inlined$isBlank(String str) {
            int len = str.length();
            if (len == 0) {
                return true;
            }
            for (int i = 0; i < len; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

