/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.requirements;

import java.util.Objects;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessingContext;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessor;
import net.skinsrestorer.shadow.cloud.key.CloudKey;
import net.skinsrestorer.shadow.cloud.processors.requirements.Requirement;
import net.skinsrestorer.shadow.cloud.processors.requirements.RequirementFailureHandler;
import net.skinsrestorer.shadow.cloud.processors.requirements.Requirements;
import net.skinsrestorer.shadow.cloud.services.type.ConsumerService;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE, since="1.0.0")
public final class RequirementPostprocessor<C, R extends Requirement<C, R>>
implements CommandPostprocessor<C> {
    private final CloudKey<Requirements<C, R>> requirementKey;
    private final RequirementFailureHandler<C, R> failureHandler;

    public static <C, R extends Requirement<C, R>> RequirementPostprocessor<C, R> of(@NonNull CloudKey<Requirements<C, R>> requirementKey, @NonNull RequirementFailureHandler<C, R> failureHandler) {
        return new RequirementPostprocessor<C, R>(requirementKey, failureHandler);
    }

    private RequirementPostprocessor(@NonNull CloudKey<Requirements<C, R>> requirementKey, @NonNull RequirementFailureHandler<C, R> failureHandler) {
        this.requirementKey = Objects.requireNonNull(requirementKey, "requirementKey");
        this.failureHandler = Objects.requireNonNull(failureHandler, "failureHandler");
    }

    @Override
    public void accept(@NonNull CommandPostprocessingContext<C> context) {
        Requirements requirements = context.command().commandMeta().getOrDefault(this.requirementKey, null);
        if (requirements == null) {
            return;
        }
        for (Requirement requirement : requirements) {
            if (requirement.evaluateRequirement(context.commandContext())) continue;
            this.failureHandler.handleFailure(context.commandContext(), requirement);
            ConsumerService.interrupt();
        }
    }
}

