/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown;

import java.time.Clock;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.skinsrestorer.shadow.cloud.Command;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownRepository;
import net.skinsrestorer.shadow.cloud.processors.cooldown.ImmutableCooldownConfiguration;
import net.skinsrestorer.shadow.cloud.processors.cooldown.listener.CooldownActiveListener;
import net.skinsrestorer.shadow.cloud.processors.cooldown.listener.CooldownCreationListener;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfileFactory;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.StandardCooldownProfileFactory;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.STABLE, since="1.0.0")
@Value.Immutable
public interface CooldownConfiguration<C> {
    public static <C> @NonNull ImmutableCooldownConfiguration.RepositoryBuildStage<C> builder() {
        return ImmutableCooldownConfiguration.builder();
    }

    public @NonNull CooldownRepository<C> repository();

    public @NonNull List<CooldownActiveListener<C>> activeCooldownListeners();

    public @NonNull List<CooldownCreationListener<C>> creationListeners();

    default public @NonNull Predicate<@NonNull CommandContext<C>> bypassCooldown() {
        return context -> false;
    }

    default public @NonNull Clock clock() {
        return Clock.systemUTC();
    }

    default public @NonNull CooldownProfileFactory profileFactory() {
        return new StandardCooldownProfileFactory(this);
    }

    default public @NonNull Function<@NonNull Command<C>, @NonNull CooldownGroup> fallbackGroup() {
        return CooldownGroup::command;
    }
}

