/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.annotations;

import java.lang.reflect.Method;
import java.util.function.Function;
import net.skinsrestorer.shadow.cloud.annotations.AnnotationParser;
import net.skinsrestorer.shadow.cloud.meta.CommandMeta;
import net.skinsrestorer.shadow.cloud.parser.ParserParameters;
import org.checkerframework.checker.nullness.qual.NonNull;

class MetaFactory
implements Function<Method, CommandMeta> {
    private final AnnotationParser<?> annotationParser;
    private final Function<ParserParameters, CommandMeta> metaMapper;

    MetaFactory(@NonNull AnnotationParser<?> annotationParser, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.annotationParser = annotationParser;
        this.metaMapper = metaMapper;
    }

    @Override
    public @NonNull CommandMeta apply(@NonNull Method method) {
        ParserParameters parameters = ParserParameters.empty();
        this.annotationParser.annotationMappers().forEach((annotationClass, mapper) -> {
            Object annotation = AnnotationParser.getMethodOrClassAnnotation(method, annotationClass);
            if (annotation != null) {
                parameters.merge(mapper.mapAnnotation(annotation));
            }
        });
        return this.metaMapper.apply(parameters);
    }
}

