/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.wrapper;

import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.skinsrestorer.bungee.wrapper.WrapperCommandSender;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={WrapperPlayerBuilderImpl.class, WrapperPlayerBuilder.class})
public class WrapperPlayer
extends WrapperCommandSender
implements SRProxyPlayer {
    @NonNull
    private final ProxiedPlayer player;

    @Override
    public Locale getLocale() {
        if (!this.settings.getProperty(MessageConfig.PER_ISSUER_LOCALE).booleanValue()) {
            return this.settings.getProperty(MessageConfig.LOCALE);
        }
        return J_U_Objects.requireNonNullElseGet(this.player.getLocale(), () -> this.settings.getProperty(MessageConfig.LOCALE));
    }

    @Override
    public Optional<String> getCurrentServer() {
        return Optional.ofNullable(this.player.getServer()).map(server -> server.getInfo().getName());
    }

    @Override
    public void sendToMessageChannel(byte[] data) {
        if (!this.player.isConnected()) {
            return;
        }
        Server server = this.player.getServer();
        if (server == null) {
            return;
        }
        server.sendData("sr:messagechannel", data);
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return true;
    }

    @Generated
    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = b.jvmdowngrader$nest$net_skinsrestorer_bungee_wrapper_WrapperPlayer$WrapperPlayerBuilder$get$player();
        if (this.player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @NotNull
    @Generated
    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    @NestHost(value=WrapperPlayer.class)
    @Generated
    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        @Generated
        private ProxiedPlayer player;

        @NotNull
        @Generated
        public B player(@NonNull ProxiedPlayer player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @NotNull
        @Generated
        public String toString() {
            return WrapperPlayerBuilder.jvmdowngrader$concat$toString$1(super.toString(), String.valueOf(this.player));
        }

        public ProxiedPlayer jvmdowngrader$nest$net_skinsrestorer_bungee_wrapper_WrapperPlayer$WrapperPlayerBuilder$get$player() {
            return this.player;
        }

        public void jvmdowngrader$nest$net_skinsrestorer_bungee_wrapper_WrapperPlayer$WrapperPlayerBuilder$set$player(ProxiedPlayer proxiedPlayer) {
            this.player = proxiedPlayer;
        }

        private static String jvmdowngrader$concat$toString$1(String string, String string2) {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + string + ", player=" + string2 + ")";
        }
    }

    @NestHost(value=WrapperPlayer.class)
    @Generated
    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        @Generated
        WrapperPlayerBuilderImpl() {
        }

        @Override
        @Generated
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        @NotNull
        @Generated
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

