/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import lombok.Generated;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.InitialHandler;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.SkinApplierBungeeNew;
import net.skinsrestorer.bungee.SkinApplierBungeeOld;
import net.skinsrestorer.bungee.SkinApplyBungeeAdapter;
import net.skinsrestorer.bungee.wrapper.WrapperBungee;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.ReflectionUtil;

public class SkinApplierBungee
implements SkinApplierAccess<ProxiedPlayer> {
    public static final boolean IS_NEW_PROPERTY_CLASS = ReflectionUtil.classExists("net.md_5.bungee.protocol.Property");
    private static final SkinApplyBungeeAdapter applyAdapter = SkinApplierBungee.selectSkinApplyAdapter();
    private final WrapperBungee wrapper;
    private final EventBusImpl eventBus;
    private final SRLogger logger;

    private static SkinApplyBungeeAdapter selectSkinApplyAdapter() {
        if (IS_NEW_PROPERTY_CLASS) {
            return new SkinApplierBungeeNew();
        }
        return new SkinApplierBungeeOld();
    }

    @Override
    public void applySkin(ProxiedPlayer player, SkinProperty property) {
        try {
            this.applyEvent(player, property, (InitialHandler)player.getPendingConnection());
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to apply skin to player %s", player.getName()), e);
        }
    }

    public void applySkin(SkinProperty property, InitialHandler handler) {
        try {
            this.applyEvent(null, property, handler);
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe("Failed to apply skin to player", e);
        }
    }

    private void applyEvent(@Nullable ProxiedPlayer player, SkinProperty property, InitialHandler handler) throws ReflectiveOperationException {
        SkinApplyEventImpl event = new SkinApplyEventImpl(player, property);
        this.eventBus.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.applyWithProperty(player, handler, event.getProperty());
    }

    private void applyWithProperty(@Nullable ProxiedPlayer player, InitialHandler handler, SkinProperty property) throws ReflectiveOperationException {
        applyAdapter.applyToHandler(handler, property);
        if (player == null) {
            return;
        }
        this.wrapper.player(player).sendToMessageChannel(new SRServerPluginMessage(new SRServerPluginMessage.SkinUpdateChannelPayload(property)));
    }

    @Inject
    @Generated
    public SkinApplierBungee(WrapperBungee wrapper, EventBusImpl eventBus, SRLogger logger) {
        this.wrapper = wrapper;
        this.eventBus = eventBus;
        this.logger = logger;
    }

    @Generated
    public static SkinApplyBungeeAdapter getApplyAdapter() {
        return applyAdapter;
    }
}

