/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.LazyBungeeAudiences;
import net.skinsrestorer.bungee.SkinApplierBungee;
import net.skinsrestorer.bungee.listeners.ForceAliveListener;
import net.skinsrestorer.bungee.wrapper.WrapperBungee;
import net.skinsrestorer.shadow.bstats.bungeecord.Metrics;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.bungee.BungeeCommandManager;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;

public class SRBungeeAdapter
implements SRProxyAdapter {
    private final Injector injector;
    private final ProxyServer proxy;
    private final Plugin pluginInstance;
    private final LazyBungeeAudiences adventure;

    @Override
    public Object createMetricsInstance() {
        return new Metrics(this.pluginInstance, 1686);
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public CommandManager<SRCommandSender> createCommandManager() {
        WrapperBungee wrapper = this.injector.getSingleton(WrapperBungee.class);
        return new BungeeCommandManager<SRCommandSender>(this.pluginInstance, ExecutionCoordinator.asyncCoordinator(), SenderMapper.create(wrapper::commandSender, wrapper::unwrap));
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.proxy.getScheduler().runAsync(this.pluginInstance, runnable);
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.proxy.getScheduler().schedule(this.pluginInstance, runnable, (long)delay, (long)interval, timeUnit);
    }

    @Override
    public void extendLifeTime(Object plugin, Object object) {
        this.proxy.getPluginManager().registerListener((Plugin)plugin, (Listener)new ForceAliveListener(object));
    }

    @Override
    public boolean supportsDefaultPermissions() {
        return false;
    }

    @Override
    public String getPlatformVersion() {
        return this.proxy.getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.proxy.getName();
    }

    @Override
    public String getPlatformVendor() {
        return "N/A";
    }

    @Override
    public Platform getPlatform() {
        return Platform.BUNGEE_CORD;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return this.proxy.getPluginManager().getPlugins().stream().map(p -> new PluginInfo(true, p.getDescription().getName(), p.getDescription().getVersion(), p.getDescription().getMain(), new String[]{p.getDescription().getAuthor()})).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return SkinApplierBungee.getApplyAdapter().getSkinProperty(player.getAs(ProxiedPlayer.class));
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers(SRCommandSender sender) {
        return this.proxy.getPlayers().stream().map(this.injector.getSingleton(WrapperBungee.class)::player).collect(Collectors.toList());
    }

    @Override
    public Optional<SRPlayer> getPlayer(SRCommandSender sender, UUID uniqueId) {
        return Optional.ofNullable(this.proxy.getPlayer(uniqueId)).map(this.injector.getSingleton(WrapperBungee.class)::player);
    }

    @Inject
    @Generated
    public SRBungeeAdapter(Injector injector, ProxyServer proxy, Plugin pluginInstance, LazyBungeeAudiences adventure) {
        this.injector = injector;
        this.proxy = proxy;
        this.pluginInstance = pluginInstance;
        this.adventure = adventure;
    }

    @Generated
    public Plugin getPluginInstance() {
        return this.pluginInstance;
    }

    @Generated
    public LazyBungeeAudiences getAdventure() {
        return this.adventure;
    }
}

