/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import lombok.Generated;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.xseries.XSound;
import net.skinsrestorer.shared.config.ServerConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.sound.SoundParser;
import net.skinsrestorer.shared.subjects.SRPlayer;
import org.bukkit.entity.Player;

public class SoundUtil {
    private final SettingsManager settings;
    private final SRLogger logger;

    public void playSound(SRPlayer player) {
        if (!this.settings.getProperty(ServerConfig.SOUND_ENABLED).booleanValue()) {
            return;
        }
        Player p = player.getAs(Player.class);
        String sound = this.settings.getProperty(ServerConfig.SOUND_VALUE);
        SoundParser.Record record = SoundParser.parse(sound);
        if (record == null) {
            this.logger.warning(J_L_String.formatted("Invalid sound value in config: %s", sound));
            return;
        }
        this.logger.debug(J_L_String.formatted("Playing sound for player: %s", player.getName()));
        XSound.Record record2 = new XSound.Record();
        record2.withSound(J_U_Optional.orElseThrow(XSound.matchXSound(record.getSound())));
        record2.inCategory(XSound.Category.valueOf(record.getCategory()));
        record2.withVolume(record.getVolume());
        record2.withPitch(record.getPitch());
        record2.soundPlayer().forPlayers(p).play();
    }

    @Inject
    @Generated
    public SoundUtil(SettingsManager settings, SRLogger logger) {
        this.settings = settings;
        this.logger = logger;
    }
}

