/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.shared.plugin.SRPlugin;
import org.bukkit.Bukkit;

public class BukkitReflection {
    public static final String CRAFTBUKKIT_PACKAGE = BukkitReflection.getCraftBukkitString();
    public static final SemanticVersion SERVER_VERSION = BukkitReflection.getServerVersion();

    public static Class<?> getBukkitClass(String clazz) throws ClassNotFoundException {
        return Class.forName(BukkitReflection.jvmdowngrader$concat$getBukkitClass$1(CRAFTBUKKIT_PACKAGE, clazz));
    }

    public static Class<?> getNMSClass(String clazz, String fullClassName) throws ClassNotFoundException {
        if (fullClassName != null) {
            try {
                return Class.forName(fullClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(BukkitReflection.jvmdowngrader$concat$getNMSClass$1(BukkitReflection.getLegacyVersionString(), clazz));
    }

    private static String getCraftBukkitString() {
        if (SRPlugin.isUnitTest()) {
            return "org.bukkit.craftbukkit";
        }
        return Bukkit.getServer().getClass().getPackage().getName();
    }

    private static SemanticVersion getServerVersion() {
        String fullVersion = Bukkit.getServer().getBukkitVersion();
        String versionString = fullVersion.substring(0, fullVersion.indexOf(45));
        return SemanticVersion.fromString(versionString);
    }

    private static String getLegacyVersionString() {
        return CRAFTBUKKIT_PACKAGE.substring(CRAFTBUKKIT_PACKAGE.lastIndexOf(46) + 1);
    }

    private static String jvmdowngrader$concat$getBukkitClass$1(String string, String string2) {
        return string + "." + string2;
    }

    private static String jvmdowngrader$concat$getNMSClass$1(String string, String string2) {
        return "net.minecraft.server." + string + "." + string2;
    }
}

