/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.AuthLibHelper;
import org.bukkit.entity.Player;

public class BukkitPropertyApplier
implements SkinApplyBukkitAdapter {
    private final SRLogger logger;

    @Override
    public void applyProperty(Player player, SkinProperty property) {
        try {
            PropertyMap properties = this.getGameProfile(player, GameProfile.class).getProperties();
            properties.removeAll((Object)"textures");
            properties.put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to apply skin property to player %s", player.getName()), e);
        }
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(Player player) {
        try {
            return this.getGameProfile(player, GameProfile.class).getProperties().values().stream().map(property -> SkinProperty.tryParse(AuthLibHelper.getPropertyName(property), AuthLibHelper.getPropertyValue(property), AuthLibHelper.getPropertySignature(property))).flatMap(J_U_Optional::stream).findFirst();
        }
        catch (ReflectiveOperationException e) {
            this.logger.severe(J_L_String.formatted("Failed to get skin property from player %s", player.getName()), e);
            return Optional.empty();
        }
    }

    @Inject
    @Generated
    public BukkitPropertyApplier(SRLogger logger) {
        this.logger = logger;
    }
}

