/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.update;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import net.skinsrestorer.bukkit.utils.PluginJarProvider;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_I_InputStream;
import net.skinsrestorer.shared.exception.UpdateException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.update.UpdateDownloader;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.bukkit.Server;
import xyz.wagyourtail.jvmdg.version.Stub;

public class UpdateDownloaderGithub
implements UpdateDownloader {
    private final SRPlugin plugin;
    private final SRLogger logger;
    private final Server server;
    private final PluginJarProvider jarProvider;

    private void download(String downloadUrl, Path targetFile, @Nullable String expectedHash) throws UpdateException {
        try {
            byte[] fileData;
            HttpsURLConnection connection = (HttpsURLConnection)URI.create(downloadUrl).toURL().openConnection();
            connection.setRequestProperty("User-Agent", this.plugin.getUserAgent());
            if (connection.getResponseCode() != 200) {
                throw new UpdateException(J_L_String.formatted("Download returned status code %d", connection.getResponseCode()));
            }
            try (InputStream is = connection.getInputStream();){
                if (is == null) {
                    throw new IOException("Failed to open input stream");
                }
                fileData = J_I_InputStream.readAllBytes(is);
                if (expectedHash != null && !expectedHash.equals(SRHelpers.hashSha256ToHex(fileData))) {
                    throw new UpdateException("Downloaded file is corrupted. SHA256 hash does not match.");
                }
                if (expectedHash == null) {
                    this.logger.warning("[GitHubUpdate] SHA256 hash not found, cannot verify integrity");
                } else {
                    this.logger.debug("[GitHubUpdate] SHA256 hash successfully verified");
                }
            }
            Files.write(targetFile, fileData, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UpdateException("Download failed", e);
        }
    }

    private String readStringFromUrl(String url) throws UpdateException {
        String string;
        block10: {
            HttpsURLConnection connection = (HttpsURLConnection)URI.create(url).toURL().openConnection();
            connection.setRequestProperty("User-Agent", this.plugin.getUserAgent());
            if (connection.getResponseCode() != 200) {
                throw new UpdateException(J_L_String.formatted("Download returned status code %d", connection.getResponseCode()));
            }
            InputStream is = connection.getInputStream();
            try {
                if (is == null) {
                    throw new IOException("Failed to open input stream");
                }
                string = new String(J_I_InputStream.readAllBytes(is), StandardCharsets.UTF_8);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UpdateException("Download failed", e);
                }
            }
            is.close();
        }
        return string;
    }

    @Override
    public boolean downloadUpdate(String downloadUrl, @Nullable String verificationAssetUrl) {
        Path pluginFile = (Path)this.jarProvider.get();
        Path updateFolder = this.server.getUpdateFolderFile().toPath();
        SRHelpers.createDirectoriesSafe(updateFolder);
        Path updateFile = updateFolder.resolve(pluginFile.getFileName());
        this.logger.info("[GitHubUpdate] Downloading update...");
        try {
            long start = System.currentTimeMillis();
            String expectedHash = verificationAssetUrl == null ? null : (String)UpdateDownloaderGithub.jvmdg$inlined$lines(this.readStringFromUrl(verificationAssetUrl)).findFirst().orElse(null);
            this.download(downloadUrl, updateFile, expectedHash);
            this.logger.info(J_L_String.formatted("[GitHubUpdate] Downloaded update in %dms", System.currentTimeMillis() - start));
            this.logger.info(J_L_String.formatted("[GitHubUpdate] Update saved as %s", updateFile.getFileName()));
            this.logger.info("[GitHubUpdate] The update will be loaded on the next server restart");
        }
        catch (UpdateException e) {
            this.logger.warning("[GitHubUpdate] Could not download update", e);
            return false;
        }
        return true;
    }

    @Inject
    @Generated
    public UpdateDownloaderGithub(SRPlugin plugin, SRLogger logger, Server server, PluginJarProvider jarProvider) {
        this.plugin = plugin;
        this.logger = logger;
        this.server = server;
        this.jarProvider = jarProvider;
    }

    @Stub
    private static Stream<String> jvmdg$inlined$lines(String str) {
        return new BufferedReader(new StringReader(str)).lines();
    }
}

