/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.refresher;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.skinsrestorer.bukkit.refresher.SkinRefresher;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.HandleReflection;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.entity.Player;

public final class PaperSkinRefresher
implements SkinRefresher {
    private final Method refreshPlayerMethod;
    private final Consumer<Player> triggerHealthUpdate;

    @Inject
    public PaperSkinRefresher() {
        try {
            this.refreshPlayerMethod = BukkitReflection.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            this.refreshPlayerMethod.setAccessible(true);
            this.triggerHealthUpdate = player -> {
                try {
                    Object entityPlayer = HandleReflection.getHandle(player, Object.class);
                    ReflectionUtil.invokeObjectMethod(entityPlayer, "triggerHealthUpdate", new ReflectionUtil.ParameterPair[0]);
                }
                catch (ReflectiveOperationException e) {
                    player.resetMaxHealth();
                }
            };
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void refresh(Player player) {
        this.refreshPlayerMethod.invoke((Object)player, new Object[0]);
        this.triggerHealthUpdate.accept(player);
    }

    @Override
    public void resendInfoPackets(Player toResend, Player toSendTo) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

