/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.refresher;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.skinsrestorer.bukkit.mappings.IMapping;
import net.skinsrestorer.bukkit.mappings.ViaPacketData;
import net.skinsrestorer.bukkit.refresher.SkinRefresher;
import net.skinsrestorer.bukkit.refresher.ViaRefreshProvider;
import net.skinsrestorer.bukkit.utils.ExceptionSupplier;
import net.skinsrestorer.bukkit.utils.MappingManager;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Set;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.subjects.messages.Message;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={UnsupportedMapping.class})
public class MappingSpigotSkinRefresher
implements SkinRefresher {
    private final IMapping mapping;
    private final ViaRefreshProvider viaProvider;

    @Inject
    public MappingSpigotSkinRefresher(Injector injector, Server server, SRLogger logger, ViaRefreshProvider viaProvider) {
        this.viaProvider = viaProvider;
        Optional<IMapping> mapping = MappingManager.getMapping(server);
        if (J_U_Optional.isEmpty(mapping)) {
            logger.severe(J_L_String.formatted("Your Minecraft version (%s) is not supported by this version of SkinsRestorer! Is there a newer version available? If not, join our discord server!", MappingManager.getVersion(server)));
            if (Boolean.getBoolean("sr.throw-if-mapping-unsupported")) {
                throw new IllegalStateException("Unsupported Minecraft version");
            }
            this.mapping = injector.getSingleton(UnsupportedMapping.class);
        } else {
            this.mapping = mapping.get();
        }
    }

    @Override
    public void refresh(Player player) {
        this.mapping.accept(player, this.viaProvider);
    }

    @Override
    public void resendInfoPackets(Player toResend, Player toSendTo) {
        this.mapping.resendInfoPackets(toResend, toSendTo);
    }

    @RecordComponents(value={@RecordComponents.Value(name="wrapper", type=WrapperBukkit.class)})
    @NestHost(value=MappingSpigotSkinRefresher.class)
    private static final class UnsupportedMapping
    extends J_L_Record
    implements IMapping {
        private final WrapperBukkit wrapper;

        @Inject
        private UnsupportedMapping(WrapperBukkit wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public void accept(Player player, Predicate<ExceptionSupplier<ViaPacketData>> viaFunction) {
            this.wrapper.player(player).sendMessage(Message.ERROR_PLAYER_REFRESH_NO_MAPPING, new TagResolver[0]);
        }

        @Override
        public void resendInfoPackets(Player toResend, Player toSendTo) {
        }

        @Override
        public Set<String> getSupportedVersions() {
            return J_U_Set.of();
        }

        @Override
        public final String toString() {
            return UnsupportedMapping.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return UnsupportedMapping.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return UnsupportedMapping.jvmdowngrader$equals$equals(this, o);
        }

        public WrapperBukkit wrapper() {
            return this.wrapper;
        }

        private static String jvmdowngrader$toString$toString(UnsupportedMapping unsupportedMapping) {
            UnsupportedMapping unsupportedMapping2 = unsupportedMapping;
            return "MappingSpigotSkinRefresher$UnsupportedMapping[" + "wrapper=" + unsupportedMapping.wrapper + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(UnsupportedMapping unsupportedMapping) {
            Object[] objectArray = new Object[]{unsupportedMapping.wrapper};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(UnsupportedMapping unsupportedMapping, Object object) {
            if (unsupportedMapping == object) {
                return true;
            }
            if (object != null && object instanceof UnsupportedMapping) {
                UnsupportedMapping unsupportedMapping2 = (UnsupportedMapping)object;
                if (Objects.equals(unsupportedMapping.wrapper, unsupportedMapping2.wrapper)) {
                    return true;
                }
            }
            return false;
        }
    }
}

