/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.LazyBukkitAudiences;
import net.skinsrestorer.bukkit.folia.FoliaSchedulerProvider;
import net.skinsrestorer.bukkit.gui.BukkitGUI;
import net.skinsrestorer.bukkit.listener.ForceAliveListener;
import net.skinsrestorer.bukkit.paper.PaperUtil;
import net.skinsrestorer.bukkit.spigot.SpigotConfigUtil;
import net.skinsrestorer.bukkit.utils.BukkitSchedulerProvider;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.bukkit.utils.SkullUtil;
import net.skinsrestorer.bukkit.wrapper.BukkitComponentHelper;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.bstats.bukkit.Metrics;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.bukkit.CloudBukkitCapabilities;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import net.skinsrestorer.shadow.cloud.paper.LegacyPaperCommandManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.javax.inject.Provider;
import net.skinsrestorer.shadow.xseries.XMaterial;
import net.skinsrestorer.shared.codec.SRServerPluginMessage;
import net.skinsrestorer.shared.gui.SRInventory;
import net.skinsrestorer.shared.info.ClassInfo;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.ProviderSelector;
import org.bukkit.Server;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SRBukkitAdapter
implements SRServerAdapter {
    private final Injector injector;
    private final Server server;
    private final JavaPlugin pluginInstance;
    private final LazyBukkitAudiences adventure;
    private final SchedulerProvider schedulerProvider;

    @Inject
    public SRBukkitAdapter(Injector injector, Server server, JavaPlugin pluginInstance, LazyBukkitAudiences adventure) {
        this.injector = injector;
        this.server = server;
        this.pluginInstance = pluginInstance;
        this.adventure = adventure;
        this.schedulerProvider = (SchedulerProvider)((Object)ProviderSelector.selector().add(FoliaSchedulerProvider::isAvailable, () -> injector.getSingleton(FoliaSchedulerProvider.class)).addDefault((Provider<SchedulerProvider>)((Object)injector.getSingleton(BukkitSchedulerProvider.class))).get());
        injector.register(SchedulerProvider.class, this.schedulerProvider);
    }

    @Override
    public Object createMetricsInstance() {
        return new Metrics((Plugin)this.pluginInstance, 1669);
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public CommandManager<SRCommandSender> createCommandManager() {
        WrapperBukkit wrapper = this.injector.getSingleton(WrapperBukkit.class);
        LegacyPaperCommandManager<SRCommandSender> commandManager = new LegacyPaperCommandManager<SRCommandSender>((Plugin)this.pluginInstance, ExecutionCoordinator.builder().commonPoolExecutor().suggestionsExecutor(ExecutionCoordinator.nonSchedulingExecutor()).build(), SenderMapper.create(wrapper::commandSender, wrapper::unwrap));
        if (commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            commandManager.registerAsynchronousCompletions();
        }
        return commandManager;
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.schedulerProvider.runAsync(runnable);
    }

    @Override
    public void runSync(SRCommandSender sender, Runnable runnable) {
        this.schedulerProvider.runSync(runnable);
    }

    @Override
    public void runSyncToPlayer(SRPlayer player, Runnable runnable) {
        this.runSyncToPlayer(player.getAs(Player.class), runnable);
    }

    @Override
    public void giveSkullItem(SRPlayer player, SRServerPluginMessage.GiveSkullChannelPayload giveSkullPayload) {
        Player bukkitPlayer = player.getAs(Player.class);
        ItemStack itemStack = Objects.requireNonNull(XMaterial.PLAYER_HEAD.parseItem());
        SkullUtil.setSkull(itemStack, giveSkullPayload.textureHash());
        ItemMeta skullMeta = Objects.requireNonNull(itemStack.getItemMeta());
        skullMeta.setDisplayName(BukkitComponentHelper.toStupidHex(giveSkullPayload.displayName()));
        itemStack.setItemMeta(skullMeta);
        bukkitPlayer.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public void runSyncToPlayer(Player player, Runnable runnable) {
        this.schedulerProvider.runSyncToEntity((Entity)player, runnable);
    }

    @Override
    public boolean determineProxy() {
        Path spigotFile = Paths.get("spigot.yml", new String[0]);
        Path paperFile = Paths.get("paper.yml", new String[0]);
        if (SpigotConfigUtil.getSpigotConfig(this.server).map(config -> config.getBoolean("settings.bungeecord")).orElse(false).booleanValue()) {
            return true;
        }
        if (ClassInfo.get().isSpigot() && Files.exists(spigotFile, new LinkOption[0]) && YamlConfiguration.loadConfiguration((File)spigotFile.toFile()).getBoolean("settings.bungeecord")) {
            return true;
        }
        if (PaperUtil.getPaperConfig(this.server).map(config -> config.getBoolean("settings.velocity-support.enabled") || config.getBoolean("proxies.velocity.enabled")).orElse(false).booleanValue()) {
            return true;
        }
        return ClassInfo.get().isPaper() && Files.exists(paperFile, new LinkOption[0]) && YamlConfiguration.loadConfiguration((File)paperFile.toFile()).getBoolean("settings.velocity-support.enabled");
    }

    @Override
    public void openGUI(SRPlayer player, SRInventory srInventory) {
        Inventory inventory = this.injector.getSingleton(BukkitGUI.class).createGUI(srInventory);
        this.runSyncToPlayer(player, () -> player.getAs(Player.class).openInventory(inventory));
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.schedulerProvider.runRepeatAsync(runnable, delay, interval, timeUnit);
    }

    @Override
    public void extendLifeTime(Object plugin, Object object) {
        this.server.getPluginManager().registerEvents((Listener)new ForceAliveListener(object), (Plugin)((JavaPlugin)plugin));
    }

    @Override
    public boolean supportsDefaultPermissions() {
        return true;
    }

    @Override
    public String getPlatformVersion() {
        return this.server.getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.server.getName();
    }

    @Override
    public String getPlatformVendor() {
        return this.server.getBukkitVersion();
    }

    @Override
    public Platform getPlatform() {
        return Platform.BUKKIT;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return Arrays.stream(this.server.getPluginManager().getPlugins()).map(plugin -> new PluginInfo(plugin.isEnabled(), plugin.getName(), plugin.getDescription().getVersion(), plugin.getDescription().getMain(), plugin.getDescription().getAuthors().toArray(new String[0]))).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return this.injector.getSingleton(SkinApplyBukkitAdapter.class).getSkinProperty(player.getAs(Player.class));
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers(SRCommandSender sender) {
        return this.server.getOnlinePlayers().stream().map(this.injector.getSingleton(WrapperBukkit.class)::player).collect(Collectors.toList());
    }

    @Override
    public Optional<SRPlayer> getPlayer(SRCommandSender sender, UUID uniqueId) {
        return Optional.ofNullable(this.server.getPlayer(uniqueId)).map(this.injector.getSingleton(WrapperBukkit.class)::player);
    }

    @Override
    public void shutdownCleanup() {
        this.schedulerProvider.unregisterTasks();
    }

    @Generated
    public JavaPlugin getPluginInstance() {
        return this.pluginInstance;
    }

    @Generated
    public LazyBukkitAudiences getAdventure() {
        return this.adventure;
    }

    @Generated
    public SchedulerProvider getSchedulerProvider() {
        return this.schedulerProvider;
    }
}

