/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.property;

import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class SkinIdentifier {
    @NonNull
    private final String identifier;
    @Nullable
    private final SkinVariant skinVariant;
    @NonNull
    private final SkinType skinType;

    public static SkinIdentifier ofPlayer(UUID uuid) {
        return new SkinIdentifier(uuid.toString(), null, SkinType.PLAYER);
    }

    public static SkinIdentifier ofURL(String url, @Nullable SkinVariant skinVariant) {
        return new SkinIdentifier(url, skinVariant, SkinType.URL);
    }

    public static SkinIdentifier ofCustom(String skinName) {
        return new SkinIdentifier(skinName.toLowerCase(Locale.ROOT), null, SkinType.CUSTOM);
    }

    @ApiStatus.Internal
    public static SkinIdentifier of(String skinIdentifier, @Nullable SkinVariant skinVariant, SkinType skinType) {
        return new SkinIdentifier(skinIdentifier, skinVariant, skinType);
    }

    public UUID getPlayerUniqueId() {
        if (this.skinType != SkinType.PLAYER) {
            throw new IllegalStateException("This skin identifier is not for a player skin.");
        }
        return UUID.fromString(this.identifier);
    }

    @NonNull
    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    @Generated
    public SkinVariant getSkinVariant() {
        return this.skinVariant;
    }

    @NonNull
    @Generated
    public SkinType getSkinType() {
        return this.skinType;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkinIdentifier)) {
            return false;
        }
        SkinIdentifier other = (SkinIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        SkinVariant this$skinVariant = this.getSkinVariant();
        SkinVariant other$skinVariant = other.getSkinVariant();
        if (this$skinVariant == null ? other$skinVariant != null : !((Object)((Object)this$skinVariant)).equals((Object)other$skinVariant)) {
            return false;
        }
        SkinType this$skinType = this.getSkinType();
        SkinType other$skinType = other.getSkinType();
        return !(this$skinType == null ? other$skinType != null : !((Object)((Object)this$skinType)).equals((Object)other$skinType));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SkinIdentifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        SkinVariant $skinVariant = this.getSkinVariant();
        result = result * 59 + ($skinVariant == null ? 43 : ((Object)((Object)$skinVariant)).hashCode());
        SkinType $skinType = this.getSkinType();
        result = result * 59 + ($skinType == null ? 43 : ((Object)((Object)$skinType)).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String toString() {
        return SkinIdentifier.jvmdowngrader$concat$toString$1(this.getIdentifier(), String.valueOf((Object)this.getSkinVariant()), String.valueOf((Object)this.getSkinType()));
    }

    @Generated
    private SkinIdentifier(@NonNull String identifier, @Nullable SkinVariant skinVariant, @NonNull SkinType skinType) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (skinType == null) {
            throw new NullPointerException("skinType is marked non-null but is null");
        }
        this.identifier = identifier;
        this.skinVariant = skinVariant;
        this.skinType = skinType;
    }

    private static String jvmdowngrader$concat$toString$1(String string, String string2, String string3) {
        return "SkinIdentifier(identifier=" + string + ", skinVariant=" + string2 + ", skinType=" + string3 + ")";
    }
}

