/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import net.skinsrestorer.api.Base64Utils;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.model.MojangProfileTextureMeta;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.jbannotations.NotNull;

public class PropertyUtils {
    public static final SkinProperty EMPTY_SKIN = SkinProperty.of("", "");
    private static final Gson GSON = new Gson();

    public static String getSkinTextureUrl(@NotNull String base64) {
        return PropertyUtils.getSkinProfileData(base64).getTextures().getSKIN().getUrl();
    }

    public static String getSkinTextureUrl(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinTextureUrl(property.getValue());
    }

    public static SkinVariant getSkinVariant(@NotNull String base64) {
        MojangProfileTextureMeta meta = PropertyUtils.getSkinProfileData(base64).getTextures().getSKIN().getMetadata();
        if (meta == null) {
            return SkinVariant.CLASSIC;
        }
        return meta.getModel().equalsIgnoreCase("slim") ? SkinVariant.SLIM : SkinVariant.CLASSIC;
    }

    public static SkinVariant getSkinVariant(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinVariant(property.getValue());
    }

    public static String getSkinTextureHash(@NotNull String base64) {
        return PropertyUtils.getSkinProfileData(base64).getTextures().getSKIN().getTextureHash();
    }

    public static String getSkinTextureHash(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinTextureHash(property.getValue());
    }

    @Deprecated(forRemoval=true)
    public static String getSkinTextureUrlStripped(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinTextureHash(property);
    }

    public static MojangProfileResponse getSkinProfileData(@NotNull String base64) {
        return GSON.fromJson(Base64Utils.decode(base64), MojangProfileResponse.class);
    }

    public static MojangProfileResponse getSkinProfileData(@NotNull SkinProperty property) {
        return PropertyUtils.getSkinProfileData(property.getValue());
    }
}

