/*
 * Decompiled with CFR 0.152.
 */
package hs.Managers;

import hs.Glitch;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerHackManager {
    public final File file = new File(Glitch.getInstance().getDataFolder(), "player_hacks.yml");
    public FileConfiguration config;
    private long lastLoadTime = 0L;

    public PlayerHackManager() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException var2) {
                IOException e = var2;
                e.printStackTrace();
            }
        }
        this.loadConfig();
    }

    public void loadConfig() {
        long now = System.currentTimeMillis();
        if (now - this.lastLoadTime >= 2000L) {
            this.lastLoadTime = now;
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
    }

    public void forceLoadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.lastLoadTime = System.currentTimeMillis();
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
        }
        catch (IOException var2) {
            IOException e = var2;
            e.printStackTrace();
        }
    }

    public void setHack(UUID playerUUID, String type, String hackName) {
        this.forceLoadConfig();
        this.config.set(String.valueOf(playerUUID) + "." + type, (Object)hackName);
        this.saveConfig();
    }

    public String getHack(UUID playerUUID, String type) {
        this.loadConfig();
        return this.config.getString(String.valueOf(playerUUID) + "." + type, (String)null);
    }

    public void removeHack(UUID playerUUID, String type) {
        this.forceLoadConfig();
        this.config.set(String.valueOf(playerUUID) + "." + type, null);
        this.saveConfig();
    }
}

