/*
 * Decompiled with CFR 0.152.
 */
package hs.Managers;

import hs.Glitch;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NameColorUpdater {
    private final Glitch plugin;
    private final Set<UUID> coloredPlayers = new HashSet<UUID>();

    public NameColorUpdater(Glitch plugin) {
        this.plugin = plugin;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String var10001;
                    UUID uuid = player.getUniqueId();
                    boolean hasChestplate = NameColorUpdater.this.hasCustomChestplate(player);
                    boolean hasMace = NameColorUpdater.this.hasCustomMace(player);
                    if (hasChestplate && hasMace) {
                        NameColorUpdater.this.coloredPlayers.add(uuid);
                        player.setPlayerListName(NameColorUpdater.this.halfColorName(player.getName(), ChatColor.RED, ChatColor.LIGHT_PURPLE));
                        player.setDisplayName(NameColorUpdater.this.halfColorName(player.getName(), ChatColor.RED, ChatColor.LIGHT_PURPLE));
                        continue;
                    }
                    if (hasChestplate) {
                        NameColorUpdater.this.coloredPlayers.add(uuid);
                        var10001 = String.valueOf(ChatColor.LIGHT_PURPLE);
                        player.setPlayerListName(var10001 + player.getName());
                        var10001 = String.valueOf(ChatColor.LIGHT_PURPLE);
                        player.setDisplayName(var10001 + player.getName());
                        continue;
                    }
                    if (hasMace) {
                        NameColorUpdater.this.coloredPlayers.add(uuid);
                        var10001 = String.valueOf(ChatColor.RED);
                        player.setPlayerListName(var10001 + player.getName());
                        var10001 = String.valueOf(ChatColor.RED);
                        player.setDisplayName(var10001 + player.getName());
                        continue;
                    }
                    if (!NameColorUpdater.this.coloredPlayers.contains(uuid)) continue;
                    NameColorUpdater.this.coloredPlayers.remove(uuid);
                    var10001 = String.valueOf(ChatColor.RESET);
                    player.setPlayerListName(var10001 + player.getName());
                    var10001 = String.valueOf(ChatColor.RESET);
                    player.setDisplayName(var10001 + player.getName());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    private boolean hasCustomChestplate(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.LEATHER_CHESTPLATE || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasCustomMace(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() != Material.MACE || !item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != 1) continue;
            return true;
        }
        return false;
    }

    private String halfColorName(String name, ChatColor first, ChatColor second) {
        int half = name.length() / 2;
        String var10000 = String.valueOf(first);
        return var10000 + name.substring(0, half) + String.valueOf(second) + name.substring(half);
    }
}

