/*
 * Decompiled with CFR 0.152.
 */
package hs.Managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private static final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();

    public static boolean isOnCooldown(UUID playerUUID, String key) {
        return CooldownManager.getCooldownTimeLeft(playerUUID, key) > 0L;
    }

    public static void setCooldown(UUID playerUUID, String key, long seconds) {
        if (!cooldowns.containsKey(playerUUID)) {
            cooldowns.put(playerUUID, new HashMap());
        }
        cooldowns.get(playerUUID).put(key, System.currentTimeMillis() + seconds * 1000L);
    }

    public static long getCooldownTimeLeft(UUID playerUUID, String key) {
        if (cooldowns.containsKey(playerUUID) && cooldowns.get(playerUUID).containsKey(key)) {
            long cooldownEnd = cooldowns.get(playerUUID).get(key);
            return cooldownEnd - System.currentTimeMillis();
        }
        return 0L;
    }

    public static Map<String, Long> getActiveCooldowns(UUID playerUUID) {
        HashMap<String, Long> activeCooldowns = new HashMap<String, Long>();
        Map<String, Long> playerCooldowns = cooldowns.get(playerUUID);
        if (playerCooldowns != null) {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<String, Long> entry : playerCooldowns.entrySet()) {
                long timeLeft = entry.getValue() - currentTime;
                if (timeLeft <= 0L) continue;
                activeCooldowns.put(entry.getKey(), timeLeft);
            }
        }
        return activeCooldowns;
    }

    public static void clearAllCooldowns(UUID playerUUID) {
        if (cooldowns.containsKey(playerUUID)) {
            cooldowns.remove(playerUUID);
        }
    }
}

