/*
 * Decompiled with CFR 0.152.
 */
package hs.Managers;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import hs.Glitch;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmorAndItemEffectsListener
implements Listener {
    @EventHandler
    public void onArmorEquip(PlayerArmorChangeEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = event.getNewItem();
        ItemStack oldItem = event.getOldItem();
        if (this.isCustomChestplate(newItem)) {
            this.playElectricEffect(player, true);
        }
        if (this.isCustomChestplate(oldItem)) {
            this.playElectricEffect(player, false);
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem().getItemStack();
        if (this.isCustomMace(item)) {
            this.playDarkRedDustEffect(player, true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemDrop().getItemStack();
        if (this.isCustomMace(item)) {
            this.playDarkRedDustEffect(player, false);
        }
    }

    private boolean isCustomChestplate(ItemStack item) {
        return item != null && item.getType() == Material.LEATHER_CHESTPLATE && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1;
    }

    private boolean isCustomMace(ItemStack item) {
        return item != null && item.getType() == Material.MACE && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1;
    }

    private void playElectricEffect(Player player, final boolean bottomToTop) {
        final Location base = player.getLocation().add(0.0, 0.1, 0.0);
        final World world = player.getWorld();
        new BukkitRunnable(this){
            double y = 0.0;

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                } else {
                    double ringY = bottomToTop ? this.y : 2.0 - this.y;
                    int points = 16;
                    double radius = 0.6;
                    for (int i = 0; i < points; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)points;
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        Location loc = base.clone().add(x, ringY, z);
                        world.spawnParticle(Particle.ELECTRIC_SPARK, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    this.y += 0.15;
                }
            }
        }.runTaskTimer((Plugin)Glitch.getInstance(), 0L, 1L);
        world.playSound(base, Sound.ENTITY_TURTLE_EGG_BREAK, 1.3f, 1.2f);
    }

    private void playDarkRedDustEffect(Player player, final boolean bottomToTop) {
        final Location base = player.getLocation().add(0.0, 0.1, 0.0);
        final World world = player.getWorld();
        new BukkitRunnable(this){
            double y = 0.0;

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                } else {
                    double ringY = bottomToTop ? this.y : 2.0 - this.y;
                    int points = 16;
                    double radius = 0.6;
                    Particle.DustOptions redDust = new Particle.DustOptions(Color.fromRGB((int)180, (int)30, (int)30), 1.5f);
                    for (int i = 0; i < points; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)points;
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        Location loc = base.clone().add(x, ringY, z);
                        world.spawnParticle(Particle.DUST, loc, 0, 0.0, 0.0, 0.0, 1.0, (Object)redDust);
                    }
                    this.y += 0.15;
                }
            }
        }.runTaskTimer((Plugin)Glitch.getInstance(), 0L, 1L);
    }
}

