/*
 * Decompiled with CFR 0.152.
 */
package hs.IMP;

import hs.Glitch;
import hs.IMP.HackMapping;
import hs.Managers.CooldownManager;
import hs.Managers.PlayerHackManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class HackEquipListener
implements Listener,
CommandExecutor {
    public final PlayerHackManager hackManager = new PlayerHackManager();

    public void handleLegendaryHack(Player player, ItemStack item, String hackName) {
        ItemMeta meta;
        ItemStack chestplate = player.getInventory().getChestplate();
        boolean hasSpecialChestplate = false;
        if (chestplate != null && chestplate.getType() == Material.DIAMOND_CHESTPLATE && (meta = chestplate.getItemMeta()) != null && meta.hasCustomModelData() && meta.getCustomModelData() == 1) {
            hasSpecialChestplate = true;
        }
        boolean hasTier1 = this.equipped(player, "1");
        boolean hasTier2 = this.equipped(player, "2");
        boolean hasTier3 = this.equipped(player, "3");
        if (hasSpecialChestplate) {
            if (hasTier1 && hasTier2 && hasTier3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must unequip an effect before equipping another!");
                return;
            }
            if (!hasTier1) {
                this.equipHack(player, item, hackName, "1");
            } else if (!hasTier2) {
                this.equipHack(player, item, hackName, "2");
            } else if (!hasTier3) {
                this.equipHack(player, item, hackName, "3");
            }
        } else {
            if (hasTier1 && hasTier2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must unequip an effect before equipping another!");
                return;
            }
            if (hasTier1) {
                this.equipHack(player, item, hackName, "2");
            } else {
                this.equipHack(player, item, hackName, "1");
            }
        }
    }

    public boolean equipped(Player player, String tier) {
        String currentHack = this.hackManager.getHack(player.getUniqueId(), tier);
        return currentHack != null && !currentHack.equals("uh");
    }

    public boolean equipHack(Player player, ItemStack item, String hackName, String type) {
        String currentHack = this.hackManager.getHack(player.getUniqueId(), type);
        if (currentHack != null) {
            return false;
        }
        this.hackManager.setHack(player.getUniqueId(), type, hackName);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have equipped " + hackName + " in slot " + type);
        this.consumeMainHandItem(player);
        return true;
    }

    @EventHandler
    public void onPlayerConsume(PlayerInteractEvent event) {
        ItemMeta meta;
        Player player = event.getPlayer();
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        if (CooldownManager.isOnCooldown(player.getUniqueId(), "hack_cooldown")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Wait before equipping another glitch");
        } else if (mainHandItem.getType() == Material.CLAY_BALL && mainHandItem.hasItemMeta() && (meta = mainHandItem.getItemMeta()) != null && meta.hasCustomModelData()) {
            HackMapping hackMapping;
            ItemMeta chestplateMeta;
            ItemStack chestplate = player.getInventory().getChestplate();
            boolean hasSpecialChestplate = false;
            if (chestplate != null && chestplate.getType() == Material.DIAMOND_CHESTPLATE && (chestplateMeta = chestplate.getItemMeta()) != null && chestplateMeta.hasCustomModelData() && chestplateMeta.getCustomModelData() == 1) {
                hasSpecialChestplate = true;
            }
            boolean hasTier1 = this.equipped(player, "1");
            boolean hasTier2 = this.equipped(player, "2");
            boolean hasTier3 = this.equipped(player, "3");
            if (hasSpecialChestplate) {
                if (hasTier1 && hasTier2 && hasTier3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You already have 3 Glitches equipped");
                    event.setCancelled(true);
                    return;
                }
            } else if (hasTier1 && hasTier2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You already have 2 Glitches equipped");
                event.setCancelled(true);
                return;
            }
            if ((hackMapping = HackMapping.fromItem(mainHandItem)) != null) {
                this.handleLegendaryHack(player, mainHandItem, hackMapping.getHackName());
                this.consumeMainHandItem(player);
                CooldownManager.setCooldown(player.getUniqueId(), "hack_cooldown", 1L);
            }
        }
    }

    public void consumeMainHandItem(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            if (mainHandItem != null && mainHandItem.getType() != Material.AIR) {
                if (mainHandItem.getAmount() > 1) {
                    mainHandItem.setAmount(mainHandItem.getAmount() - 1);
                } else {
                    player.getInventory().setItemInMainHand((ItemStack)null);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.dropHackOnDeath(player, "1");
        this.dropHackOnDeath(player, "2");
        this.dropHackOnDeath(player, "3");
    }

    public void dropHackOnDeath(Player player, String type) {
        String hackName = this.hackManager.getHack(player.getUniqueId(), type);
        if (hackName != null) {
            this.hackManager.removeHack(player.getUniqueId(), type);
            HackMapping hackMapping = HackMapping.fromHackName(hackName);
            if (hackMapping != null) {
                Location dropLocation;
                ItemStack item = hackMapping.createItem();
                Location deathLocation = player.getLocation();
                World world = player.getWorld();
                if (deathLocation.getY() <= -70.0) {
                    Location spawnLocation = world.getSpawnLocation();
                    int highestY = world.getHighestBlockYAt(spawnLocation.getBlockX(), spawnLocation.getBlockZ());
                    dropLocation = new Location(world, spawnLocation.getX(), (double)(highestY + 1), spawnLocation.getZ());
                } else {
                    dropLocation = deathLocation;
                }
                Item droppedItem = world.dropItemNaturally(dropLocation, item);
                Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
                    if (droppedItem.isValid()) {
                        droppedItem.setGlowing(true);
                    }
                }, 10L);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        String hack1 = this.hackManager.getHack(player.getUniqueId(), "1");
        String hack2 = this.hackManager.getHack(player.getUniqueId(), "2");
        if (hack1 == null && hack2 == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have any Glitches equipped to swap.");
            return true;
        }
        this.hackManager.setHack(player.getUniqueId(), "1", hack2 != null ? hack2 : "");
        this.hackManager.setHack(player.getUniqueId(), "2", hack1 != null ? hack1 : "");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your Glitches have been swapped.");
        return true;
    }
}

