/*
 * Decompiled with CFR 0.152.
 */
package hs.IMP;

import hs.Managers.CooldownManager;
import hs.Managers.PlayerHackManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarUpdater
extends BukkitRunnable {
    private final PlayerHackManager hackManager = new PlayerHackManager();
    private final CooldownManager cooldownManager = new CooldownManager();
    private final Set<UUID> playersWithActiveEffects = new HashSet<UUID>();
    private final Map<String, String> hackCooldownKeys = new HashMap<String, String>();

    public ActionBarUpdater() {
        this.hackCooldownKeys.put("Herobrine Glitch", "creative_flight");
        this.hackCooldownKeys.put("Freeze Glitch", "FullFreeze");
        this.hackCooldownKeys.put("Invisibility Glitch", "FullInvis22");
        this.hackCooldownKeys.put("Immunity Glitch", "bullet_proof");
        this.hackCooldownKeys.put("Soul Splitter Glitch", "soul");
        this.hackCooldownKeys.put("Teleport Glitch", "tp");
        this.hackCooldownKeys.put("Effect Glitch", "pot");
        this.hackCooldownKeys.put("Inventory Glitch", "inventory_glitch");
        this.hackCooldownKeys.put("Item Glitch", "Item");
        this.hackCooldownKeys.put("Virus Glitch", "virus_glitch");
        this.hackCooldownKeys.put("Glide Glitch", "glide");
        this.hackCooldownKeys.put("Fake Block Glitch", "fake");
        this.hackCooldownKeys.put("Telekinesis Glitch", "tele");
        this.hackCooldownKeys.put("Horse Tamer Glitch", "horse");
        this.hackCooldownKeys.put("Morph Glitch", "morph");
        this.hackCooldownKeys.put("Dream Glitch", "dream");
        this.hackCooldownKeys.put("Crasher Glitch", "crasher");
        this.hackCooldownKeys.put("Dash Glitch", "dash");
        this.hackCooldownKeys.put("Dupe Glitch", "dupe");
        this.hackCooldownKeys.put("Raycast Glitch", "raycast");
        this.hackCooldownKeys.put("Shulker Glitch", "shulker");
        this.hackCooldownKeys.put("Redstone Glitch", "redstone");
        this.hackCooldownKeys.put("Diffuser Glitch", "diffuser");
    }

    public void addPlayerWithActiveEffect(UUID playerUUID) {
        this.playersWithActiveEffects.add(playerUUID);
    }

    public void removePlayerWithActiveEffect(UUID playerUUID) {
        this.playersWithActiveEffects.remove(playerUUID);
    }

    public void run() {
        Iterator var1 = Bukkit.getOnlinePlayers().iterator();
        while (var1.hasNext()) {
            boolean hasSecond;
            Player player = (Player)var1.next();
            UUID uuid = player.getUniqueId();
            if (this.playersWithActiveEffects.contains(uuid)) continue;
            String firstTime = "";
            String firstEmoji = "";
            String commonHack = this.hackManager.getHack(uuid, "1");
            if (commonHack != null) {
                firstEmoji = this.getCommonHackEmoji(commonHack);
                firstTime = this.getHackDisplayWithCooldown(uuid, commonHack, true);
            }
            String secondTime = "";
            String secondEmoji = "";
            String legendaryHack = this.hackManager.getHack(uuid, "2");
            if (legendaryHack != null) {
                secondEmoji = this.getLegendaryHackEmoji(legendaryHack);
                secondTime = this.getHackDisplayWithCooldown(uuid, legendaryHack, false);
            }
            String invisiblePlaceholder = "\u00a0\u00a0\u00a0\u00a0\u00a0";
            String sidePadding = "\u00a0\u00a0\u00a0\u00a0";
            String extraPadding = "\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0";
            String formattedFirstTime = firstTime.isEmpty() ? invisiblePlaceholder : firstTime;
            String formattedFirstEmoji = firstEmoji.isEmpty() ? invisiblePlaceholder : firstEmoji;
            String formattedSecondTime = secondTime.isEmpty() ? invisiblePlaceholder : secondTime;
            String formattedSecondEmoji = secondEmoji.isEmpty() ? invisiblePlaceholder : secondEmoji;
            boolean hasFirst = !firstTime.isEmpty() || !firstEmoji.isEmpty();
            boolean bl = hasSecond = !secondTime.isEmpty() || !secondEmoji.isEmpty();
            Object actionBarMessage = hasFirst && hasSecond ? sidePadding + " " + formattedFirstTime + " " + formattedFirstEmoji + " " + formattedSecondEmoji + " " + formattedSecondTime + " " + sidePadding : (hasFirst ? sidePadding + " " + formattedFirstTime + " " + formattedFirstEmoji + " \ue100 " + invisiblePlaceholder + " " + sidePadding : (hasSecond ? sidePadding + " " + invisiblePlaceholder + " \ue100 " + formattedSecondEmoji + " " + formattedSecondTime + " " + sidePadding : sidePadding + " \ue100 \ue100" + sidePadding));
            if (((String)(actionBarMessage = ((String)actionBarMessage).trim())).isEmpty()) continue;
            player.sendActionBar((String)actionBarMessage);
        }
        return;
    }

    private String getHackDisplayWithCooldown(UUID playerUUID, String hack, boolean isCommonHack) {
        boolean isOnCooldown;
        if (hack == null) {
            return "";
        }
        if (isCommonHack) {
            this.getCommonHackEmoji(hack);
        } else {
            this.getLegendaryHackEmoji(hack);
        }
        String cooldownKey = this.hackCooldownKeys.get(ChatColor.stripColor((String)hack));
        boolean bl = isOnCooldown = cooldownKey != null && CooldownManager.isOnCooldown(playerUUID, cooldownKey);
        if (isOnCooldown) {
            long timeLeftMillis = CooldownManager.getCooldownTimeLeft(playerUUID, cooldownKey);
            long timeLeftSeconds = timeLeftMillis / 1000L;
            long minutes = timeLeftSeconds / 60L;
            long seconds = timeLeftSeconds % 60L;
            String superscriptM = "\ue002";
            String superscriptS = "\ue001";
            return this.convertToSuperscript(minutes) + superscriptM + " " + this.convertToSuperscript(seconds) + superscriptS;
        }
        return "";
    }

    private String convertToSuperscript(long number) {
        String normal = String.valueOf(number);
        StringBuilder superscript = new StringBuilder();
        for (char digit : normal.toCharArray()) {
            superscript.append(this.convertDigitToSuperscript(digit));
        }
        return superscript.toString();
    }

    private String convertDigitToSuperscript(char digit) {
        switch (digit) {
            case '0': {
                return "\u2070";
            }
            case '1': {
                return "\u00b9";
            }
            case '2': {
                return "\u00b2";
            }
            case '3': {
                return "\u00b3";
            }
            case '4': {
                return "\u2074";
            }
            case '5': {
                return "\u2075";
            }
            case '6': {
                return "\u2076";
            }
            case '7': {
                return "\u2077";
            }
            case '8': {
                return "\u2078";
            }
            case '9': {
                return "\u2079";
            }
        }
        return String.valueOf(digit);
    }

    private String getCommonHackEmoji(String commonHack) {
        switch (ChatColor.stripColor((String)commonHack)) {
            case "Herobrine Glitch": {
                return "\ue112";
            }
            case "Freeze Glitch": {
                return "\ue101";
            }
            case "Immunity Glitch": {
                return "\ue108";
            }
            case "Teleport Glitch": {
                return "\ue114";
            }
            case "Virus Glitch": {
                return "\ue111";
            }
            case "Invisibility Glitch": {
                return "\ue106";
            }
            case "Item Glitch": {
                return "\ue117";
            }
            case "Effect Glitch": {
                return "\ue115";
            }
            case "Inventory Glitch": {
                return "\ue116";
            }
            case "Morph Glitch": {
                return "\ue110";
            }
            case "Fake Block Glitch": {
                return "\ue103";
            }
            case "Glide Glitch": {
                return "\ue105";
            }
            case "Horse Tamer Glitch": {
                return "\ue118";
            }
            case "Telekinesis Glitch": {
                return "\ue122";
            }
            case "Soul Splitter Glitch": {
                return "\ue124";
            }
            case "Crasher Glitch": {
                return "\ue109";
            }
            case "Dash Glitch": {
                return "\ue119";
            }
            case "Xray Glitch": {
                return "\ue121";
            }
            case "Raycast Glitch": {
                return "\ue123";
            }
            case "Shulker Glitch": {
                return "\ue126";
            }
            case "Rewind Glitch": {
                return "\ue125";
            }
            case "Dupe Glitch": {
                return "\ue102";
            }
            case "Redstone Glitch": {
                return "\ue104";
            }
            case "Diffuser Glitch": {
                return "\ue107";
            }
            case "Dream Glitch": {
                return "\ue113";
            }
        }
        return "\ue100";
    }

    private String getLegendaryHackEmoji(String legendaryHack) {
        return this.getCommonHackEmoji(legendaryHack);
    }
}

