/*
 * Decompiled with CFR 0.152.
 */
package hs.IMP;

import hs.Glitch;
import hs.IMP.AbilityCreator;
import hs.Managers.PlayerHackManager;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AbilityMenuListener
implements Listener {
    private final PlayerHackManager hackManager;
    private final String MENU_TITLE = String.valueOf(ChatColor.DARK_PURPLE) + "Select an Ability";

    public AbilityMenuListener(PlayerHackManager hackManager) {
        this.hackManager = hackManager;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        ItemMeta meta;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.NETHER_STAR && item.hasItemMeta() && (meta = item.getItemMeta()).hasCustomModelData() && meta.getCustomModelData() == 9) {
            event.setCancelled(true);
            this.openAbilityGUI(player);
        }
    }

    private void openAbilityGUI(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)null, (int)54, (String)this.MENU_TITLE);
        List<ItemStack> abilities = Arrays.asList(AbilityCreator.createItem(), AbilityCreator.createFreeze(), AbilityCreator.createImmunity(), AbilityCreator.createTeleport(), AbilityCreator.createEffect(), AbilityCreator.createHerobrine(), AbilityCreator.createVirus(), AbilityCreator.createInventory(), AbilityCreator.createInvisibility(), AbilityCreator.createGlide(), AbilityCreator.createMorph(), AbilityCreator.createHorseTamer(), AbilityCreator.createTele(), AbilityCreator.createDream(), AbilityCreator.createSoulSplitter(), AbilityCreator.createDash(), AbilityCreator.createDiffuser(), AbilityCreator.createDupe(), AbilityCreator.createRaycast(), AbilityCreator.createShulker(), AbilityCreator.createRedstone(), AbilityCreator.createFakeBlock());
        for (int i = 0; i < abilities.size(); ++i) {
            gui.setItem(i, abilities.get(i));
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getView().getTitle().equals(this.MENU_TITLE)) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && clicked.hasItemMeta() && clicked.getItemMeta().hasDisplayName()) {
                String coloredName = clicked.getItemMeta().getDisplayName();
                String strippedName = ChatColor.stripColor((String)coloredName);
                if (!this.equipped(player, "1")) {
                    this.hackManager.setHack(player.getUniqueId(), "1", strippedName);
                } else {
                    this.hackManager.setHack(player.getUniqueId(), "2", strippedName);
                }
                player.closeInventory();
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item != null && item.getAmount() > 0) {
                    item.setAmount(item.getAmount() - 1);
                }
                this.effect(player);
            }
        }
    }

    private void effect(Player player) {
        final Location base = player.getLocation().add(0.0, 0.1, 0.0);
        final World world = player.getWorld();
        player.playSound(player.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_SET_SPAWN, 1.0f, 1.0f);
        new BukkitRunnable(this){
            double y = 0.0;

            public void run() {
                if (this.y > 2.0) {
                    this.cancel();
                } else {
                    int points = 16;
                    double radius = 0.6;
                    for (int i = 0; i < points; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)points;
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        Location loc = base.clone().add(x, this.y, z);
                        world.spawnParticle(Particle.FALLING_OBSIDIAN_TEAR, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    this.y += 0.15;
                }
            }
        }.runTaskTimer((Plugin)Glitch.getInstance(), 0L, 1L);
    }

    private boolean equipped(Player player, String tier) {
        String currentHack = this.hackManager.getHack(player.getUniqueId(), tier);
        return currentHack != null && !currentHack.equals("uh");
    }
}

