/*
 * Decompiled with CFR 0.152.
 */
package hs.IMP;

import hs.Glitch;
import hs.IMP.ActionBarUpdater;
import hs.Managers.CooldownManager;
import hs.Managers.PlayerHackManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class Abilities
implements CommandExecutor,
Listener {
    public final PlayerHackManager hackManager = new PlayerHackManager();
    public final CooldownManager cooldownManager = new CooldownManager();
    private final Glitch plugin;
    private final Set<UUID> frozenPlayers = new HashSet<UUID>();
    private final Random random = new Random();
    private static final HashMap<UUID, Integer> herobrineCritCount = new HashMap();
    private static final HashMap<UUID, BukkitRunnable> herobrinePlayers = new HashMap();
    private static final String HEROBRINE_TEAM = "HerobrineTeam";
    public static final long COOLDOWNDREAM = Glitch.getInstance().getConfig().getLong("cooldowns.Dream");
    public static final long COOLDOWNFREEZE = Glitch.getInstance().getConfig().getLong("cooldowns.Freeze");
    public static final long COOLDOWNFAKEBLOCK = Glitch.getInstance().getConfig().getLong("cooldowns.Fake");
    public static final long COOLDOWNTP = Glitch.getInstance().getConfig().getLong("cooldowns.TP");
    public static final long COOLDOWNGLIDE = Glitch.getInstance().getConfig().getLong("cooldowns.Glide");
    public static final long COOLDOWNHORSE = Glitch.getInstance().getConfig().getLong("cooldowns.Horse");
    public static final long COOLDOWNIMMUNITY = Glitch.getInstance().getConfig().getLong("cooldowns.Immunity");
    public static final long COOLDOWNINVENTORY = Glitch.getInstance().getConfig().getLong("cooldowns.Inven");
    public static final long COOLDOWNINVIS = Glitch.getInstance().getConfig().getLong("cooldowns.Invis");
    public static final long COOLDOWNMORPH = Glitch.getInstance().getConfig().getLong("cooldowns.Morph");
    public static final long COOLDOWNITEM = Glitch.getInstance().getConfig().getLong("cooldowns.Item");
    public static final long COOLDOWNEFFECT = Glitch.getInstance().getConfig().getLong("cooldowns.Effect");
    public static final long COOLDOWNVIRUS = Glitch.getInstance().getConfig().getLong("cooldowns.Virus");
    public static final long COOLDOWNTELE = Glitch.getInstance().getConfig().getLong("cooldowns.Tele");
    public static final long COOLDOWNSOUL = Glitch.getInstance().getConfig().getLong("cooldowns.Soul");
    public static final long COOLDOWNHEROBRINE = Glitch.getInstance().getConfig().getLong("cooldowns.Herobrine");
    public static final long COOLDOWNHDIFFUESER = Glitch.getInstance().getConfig().getLong("cooldowns.Diffuser");
    public static final long COOLDOWNREDSTONE = Glitch.getInstance().getConfig().getLong("cooldowns.Redstone");
    public static final long COOLDOWNCRASHER = Glitch.getInstance().getConfig().getLong("cooldowns.Crasher");
    public static final long COOLDOWNDASH = Glitch.getInstance().getConfig().getLong("cooldowns.Dash");
    public static final long COOLDOWNXRAY = Glitch.getInstance().getConfig().getLong("cooldowns.Xray");
    public static final long COOLDOWNRAYCAST = Glitch.getInstance().getConfig().getLong("cooldowns.Raycast");
    public static final long COOLDOWNSHULKER = Glitch.getInstance().getConfig().getLong("cooldowns.Shulker");
    public static final long COOLDOWNREWIND = Glitch.getInstance().getConfig().getLong("cooldowns.Rewind");
    public static final long COOLDOWNDUPE = Glitch.getInstance().getConfig().getLong("cooldowns.Dupe");
    private final Map<UUID, FallingBlock> ghostBlocks = new HashMap<UUID, FallingBlock>();
    private static final String DREAM_TEAM = "DreamTeam";
    private static final HashMap<UUID, BukkitRunnable> herobrinePlayers2 = new HashMap();
    private final ConcurrentHashMap<UUID, Long> dismountCooldowns = new ConcurrentHashMap();
    private final Map<UUID, Boolean> pendingGlitchAttack = new HashMap<UUID, Boolean>();
    private final Map<World, UUID> noDamageCaster = new HashMap<World, UUID>();
    private final Map<World, Long> weaponDamageDisabledUntil = new HashMap<World, Long>();
    private final Map<UUID, Boolean> pendingMorphAttack = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> pendingVirusAttack = new HashMap<UUID, Boolean>();
    private final Set<UUID> activeVirusEffects = new HashSet<UUID>();
    private final ActionBarUpdater actionBarUpdater = new ActionBarUpdater();
    private final Map<UUID, BossBar> activeBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, Boolean> pendingTelekinesis = new HashMap<UUID, Boolean>();
    private final Map<UUID, LivingEntity> controlledTargets = new HashMap<UUID, LivingEntity>();
    private final Set<UUID> preparedSoul = new HashSet<UUID>();
    private final Map<UUID, StoredData> storedInventories = new HashMap<UUID, StoredData>();
    private final Set<Block> redstoneBlocked = new HashSet<Block>();
    private boolean isRedstoneDisabled = false;
    private final Set<UUID> crasherReady = new HashSet<UUID>();
    private final Map<UUID, Long> blockedRejoin = new HashMap<UUID, Long>();
    private final Map<UUID, Inventory> openShulkerMenus = new HashMap<UUID, Inventory>();
    private final Set<UUID> invenActive = new HashSet<UUID>();

    public Abilities(Glitch plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String slot;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (label.equalsIgnoreCase("ability1")) {
            slot = "1";
        } else if (label.equalsIgnoreCase("ability2")) {
            slot = "2";
        } else {
            if (!label.equalsIgnoreCase("ability3")) {
                return false;
            }
            slot = "3";
        }
        String equippedHack = this.hackManager.getHack(playerUUID, slot);
        if (equippedHack == null) {
            String var10001 = String.valueOf(ChatColor.RED);
            player.sendMessage(var10001 + "You don't have any effect equipped in slot " + slot + ".");
            return true;
        }
        if (CooldownManager.isOnCooldown(player.getUniqueId(), "diffused")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your glitch is currently Diffused");
            return true;
        }
        String strippedHack = ChatColor.stripColor((String)equippedHack);
        this.activateAbility(player, strippedHack);
        return true;
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("offhand")) {
            if (CooldownManager.isOnCooldown(player.getUniqueId(), "diffused")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your glitch is currently Diffused");
            } else {
                String abilitySlot = player.isSneaking() ? "1" : "2";
                this.activateAbility2(player, abilitySlot);
                event.setCancelled(true);
            }
        }
    }

    public void activateAbility2(Player player, String abilitySlot) {
        String equippedHack = this.hackManager.getHack(player.getUniqueId(), abilitySlot);
        if (equippedHack != null) {
            String strippedHack = ChatColor.stripColor((String)equippedHack);
            this.activateAbility(player, strippedHack);
        }
    }

    public void activateAbility(Player player, String abilityName) {
        switch (abilityName) {
            case "Freeze Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "FullFreeze")) {
                    return;
                }
                Player target = this.getPlayerInSight(player, 50.0);
                if (target == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No player in sight to freeze.");
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "FullFreeze", COOLDOWNFREEZE);
                this.freezePlayer(target);
                this.freeze(target);
                break;
            }
            case "Dream Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "dream")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "dream", COOLDOWNDREAM);
                this.dream(player);
                break;
            }
            case "Fake Block Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "fake")) {
                    return;
                }
                ItemStack heldItem = player.getInventory().getItemInMainHand();
                if (heldItem == null || heldItem.getType() == Material.AIR) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must hold a block to spawn a ghost block!");
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "fake", COOLDOWNFAKEBLOCK);
                this.activateFakeBlock(player);
                break;
            }
            case "Teleport Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "tp")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "tp", COOLDOWNTP);
                this.Teleport(player);
                break;
            }
            case "Glide Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "glide")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "glide", COOLDOWNGLIDE);
                this.glide(player);
                break;
            }
            case "Horse Tamer Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "horse")) {
                    return;
                }
                if (player.isInsideVehicle()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Get off what you are riding first");
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "horse", COOLDOWNHORSE);
                this.horse(player);
                break;
            }
            case "Immunity Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "bullet_proof")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "bullet_proof", COOLDOWNIMMUNITY);
                this.immune(player);
                break;
            }
            case "Herobrine Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "creative_flight")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "creative_flight", COOLDOWNHEROBRINE);
                this.turnIntoHerobrine(player);
                break;
            }
            case "Inventory Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "inventory_glitch")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "inventory_glitch", COOLDOWNINVENTORY);
                this.Inven(player);
                break;
            }
            case "Invisibility Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "FullInvis22")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "FullInvis22", COOLDOWNINVIS);
                this.Invis(player);
                break;
            }
            case "Item Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "Item")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "Item", COOLDOWNITEM);
                this.item(player);
                break;
            }
            case "Morph Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "morph")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "morph", COOLDOWNMORPH);
                this.Morph(player);
                break;
            }
            case "Effect Glitch": {
                if (player.getActivePotionEffects().isEmpty()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You have no potion effects to upgrade!");
                    return;
                }
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "pot")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "pot", COOLDOWNEFFECT);
                this.effect(player);
                break;
            }
            case "Telekinesis Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "tele")) {
                    return;
                }
                this.tele(player);
                break;
            }
            case "Virus Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "virus_glitch")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "virus_glitch", COOLDOWNVIRUS);
                this.virus(player);
                break;
            }
            case "Soul Splitter Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "soul")) {
                    return;
                }
                this.prepareSoul(player);
                break;
            }
            case "Diffuser Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "diffuser")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "diffuser", COOLDOWNHDIFFUESER);
                this.diffuse(player);
                break;
            }
            case "Redstone Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "redstone")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "redstone", COOLDOWNREDSTONE);
                this.redstone(player);
                break;
            }
            case "Crasher Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "crasher")) {
                    return;
                }
                this.crasher(player);
                break;
            }
            case "Dash Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "dash")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "dash", COOLDOWNDASH);
                this.dash(player);
                break;
            }
            case "Xray Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "xray")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "xray", COOLDOWNXRAY);
                this.diffuse(player);
                break;
            }
            case "Shulker Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "shulker")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "shulker", COOLDOWNSHULKER);
                this.shulker(player);
                break;
            }
            case "Raycast Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "raycast")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "raycast", COOLDOWNRAYCAST);
                this.raycast(player);
                break;
            }
            case "Dupe Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "dupe")) {
                    return;
                }
                this.dupe(player);
                break;
            }
            case "Rewind Glitch": {
                if (CooldownManager.isOnCooldown(player.getUniqueId(), "rewind")) {
                    return;
                }
                CooldownManager.setCooldown(player.getUniqueId(), "rewind", COOLDOWNREWIND);
                break;
            }
            default: {
                String var10001 = String.valueOf(ChatColor.RED);
                player.sendMessage(var10001 + "Unknown ability: " + abilityName);
            }
        }
    }

    public void activateFakeBlock(final Player player) {
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (!heldItem.getType().isBlock()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must hold a valid block item!");
        } else {
            Location playerLocation = player.getLocation();
            Location spawnLocation = new Location(player.getWorld(), (double)playerLocation.getBlockX() + 0.5, (double)playerLocation.getBlockY(), (double)playerLocation.getBlockZ() + 0.5);
            BlockData blockData = heldItem.getType().createBlockData();
            final FallingBlock ghostBlock = player.getWorld().spawnFallingBlock(spawnLocation, blockData);
            ghostBlock.setGravity(false);
            ghostBlock.setDropItem(false);
            ghostBlock.setCustomName("\u00a70");
            ghostBlock.setCustomNameVisible(false);
            ghostBlock.setInvulnerable(true);
            this.ghostBlocks.put(player.getUniqueId(), ghostBlock);
            new BukkitRunnable(){

                public void run() {
                    if (ghostBlock.isValid()) {
                        if (!ghostBlock.getLocation().getChunk().isLoaded()) {
                            ghostBlock.remove();
                            Abilities.this.ghostBlocks.remove(player.getUniqueId());
                            this.cancel();
                        }
                    } else {
                        Abilities.this.ghostBlocks.remove(player.getUniqueId());
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Glitch.getInstance(), 0L, 20L);
            if (heldItem.getAmount() > 1) {
                heldItem.setAmount(heldItem.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand((ItemStack)null);
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have spawned a ghost block!");
        }
    }

    @EventHandler
    public void onPlayerAttackGhostBlock(EntityDamageByEntityEvent event) {
        FallingBlock fallingBlock;
        Entity var3 = event.getEntity();
        if (var3 instanceof FallingBlock && "\u00a70".equals((fallingBlock = (FallingBlock)var3).getCustomName())) {
            this.removeGhostBlock(fallingBlock);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteractGhostBlock(PlayerInteractEvent event) {
        FallingBlock fallingBlock;
        Entity var3 = event.getPlayer().getTargetEntity(5);
        if (var3 instanceof FallingBlock && "\u00a70".equals((fallingBlock = (FallingBlock)var3).getCustomName())) {
            this.removeGhostBlock(fallingBlock);
            event.setCancelled(true);
        }
    }

    private void removeGhostBlock(FallingBlock fallingBlock) {
        Material blockType = fallingBlock.getBlockData().getMaterial();
        fallingBlock.getWorld().dropItemNaturally(fallingBlock.getLocation(), new ItemStack(blockType));
        fallingBlock.remove();
    }

    private void dream(final Player player) {
        final UUID playerId = player.getUniqueId();
        herobrinePlayers2.remove(playerId);
        String var10001 = String.valueOf(ChatColor.GREEN);
        player.setDisplayName(var10001 + "Dream" + String.valueOf(ChatColor.RESET));
        var10001 = String.valueOf(ChatColor.GREEN);
        player.setPlayerListName(var10001 + "Dream" + String.valueOf(ChatColor.RESET));
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("skin set Dream " + player.getName()));
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(DREAM_TEAM);
        if (team == null) {
            team = scoreboard.registerNewTeam(DREAM_TEAM);
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
        team.addEntry(player.getName());
        player.addPotionEffect(new PotionEffect(PotionEffectType.LUCK, 400, 254, true, false));
        final Team finalTeam = team;
        BukkitRunnable reset = new BukkitRunnable(this){

            public void run() {
                player.setDisplayName(player.getName());
                player.setPlayerListName(player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("skin clear " + player.getName()));
                if (finalTeam.hasEntry(player.getName())) {
                    finalTeam.removeEntry(player.getName());
                }
                herobrinePlayers2.remove(playerId);
            }
        };
        reset.runTaskLater((Plugin)Glitch.getInstance(), 400L);
        herobrinePlayers2.put(playerId, reset);
    }

    private void freezePlayer(Player target) {
        if (!target.isDead()) {
            this.frozenPlayers.add(target.getUniqueId());
            target.setWalkSpeed(0.0f);
            target.setFlySpeed(0.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
                this.frozenPlayers.remove(target.getUniqueId());
                if (!target.isDead()) {
                    target.setWalkSpeed(0.2f);
                    target.setFlySpeed(0.1f);
                }
            }, 100L);
        }
    }

    private void freeze(final Player target) {
        if (!target.isDead()) {
            final Location freezeLocation = target.getLocation();
            new BukkitRunnable(){
                int ticks = 0;

                public void run() {
                    if (this.ticks < 100 && !target.isDead() && Abilities.this.frozenPlayers.contains(target.getUniqueId())) {
                        double xOffset = Abilities.this.random.nextDouble() * 1.0 - 0.2;
                        double zOffset = Abilities.this.random.nextDouble() * 1.0 - 0.2;
                        Location newLocation = freezeLocation.clone().add(xOffset, 0.0, zOffset);
                        target.teleport(newLocation);
                        this.ticks += 2;
                    } else {
                        Abilities.this.frozenPlayers.remove(target.getUniqueId());
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Glitch.getInstance(), 0L, 2L);
        }
    }

    @EventHandler
    public void onFrozenPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.frozenPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFrozenPlayerAttack(EntityDamageByEntityEvent event) {
        Player player;
        Entity var3 = event.getDamager();
        if (var3 instanceof Player && this.frozenPlayers.contains((player = (Player)var3).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private Player getPlayerInSight(Player player, double maxDistance) {
        List nearby = player.getNearbyEntities(maxDistance, maxDistance, maxDistance);
        Location eye = player.getEyeLocation();
        Vector direction = eye.getDirection().normalize();
        for (double i = 0.0; i < maxDistance; i += 0.5) {
            Location checkLoc = eye.clone().add(direction.clone().multiply(i));
            for (Entity entity : nearby) {
                Player target;
                if (!(entity instanceof Player) || (target = (Player)entity).equals((Object)player) || !(entity.getLocation().distanceSquared(checkLoc) < 1.0)) continue;
                return target;
            }
        }
        return null;
    }

    private void Teleport(final Player player) {
        Location targetLocation;
        double maxDistance;
        Vector direction;
        Location eyeLocation;
        final World world = player.getWorld();
        RayTraceResult result = world.rayTraceBlocks(eyeLocation = player.getEyeLocation(), direction = eyeLocation.getDirection(), maxDistance = 20.0, FluidCollisionMode.NEVER, true);
        if (result != null && result.getHitBlock() != null) {
            targetLocation = this.findSafeLocation(player, result, direction, world);
            if (targetLocation == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No safe spot found near that block!");
                return;
            }
        } else {
            targetLocation = eyeLocation.clone().add(direction.multiply(maxDistance));
            targetLocation.setY(Math.max(targetLocation.getY(), 1.0));
        }
        Location startLocation = player.getLocation();
        Location armorStandLocation = startLocation.clone().subtract(0.0, 1.7, 0.0);
        final ArmorStand stand = (ArmorStand)world.spawn(armorStandLocation, ArmorStand.class, a -> {
            a.setInvisible(true);
            a.setInvulnerable(true);
            a.setGravity(false);
            a.setMarker(true);
            a.setSilent(true);
            a.setCollidable(false);
            a.getEquipment().setHelmet(this.createFlintModelItem());
            a.setCustomNameVisible(false);
        });
        world.spawnParticle(Particle.END_ROD, armorStandLocation.clone().add(0.0, 2.0, 0.0), 6, 0.2, 0.2, 0.2, 0.0);
        stand.getAttribute(Attribute.GENERIC_SCALE).setBaseValue(1.5);
        new BukkitRunnable(this){

            public void run() {
                stand.remove();
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 60L);
        new BukkitRunnable(this){

            public void run() {
                player.teleport(targetLocation);
                world.playSound(targetLocation, Sound.ENTITY_PLAYER_TELEPORT, 1.0f, 1.0f);
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 1L);
    }

    private ItemStack createFlintModelItem() {
        ItemStack item = new ItemStack(Material.FLINT);
        item.editMeta(meta -> meta.setCustomModelData(Integer.valueOf(1)));
        return item;
    }

    private Location findSafeLocation(Player player, RayTraceResult result, Vector direction, World world) {
        Block hitBlock = result.getHitBlock();
        if (hitBlock == null) {
            return null;
        }
        Location tryLocation = hitBlock.getLocation().clone();
        for (int i = 0; i < 20; ++i) {
            if (this.isSafeSpot(tryLocation)) {
                return tryLocation.setDirection(direction);
            }
            tryLocation.add(direction.clone().multiply(-0.5));
        }
        Location safeAbove = hitBlock.getLocation();
        for (int y = 0; y < 10; ++y) {
            safeAbove.add(0.0, 1.0, 0.0);
            if (!this.isSafeSpot(safeAbove)) continue;
            return safeAbove.setDirection(direction);
        }
        return null;
    }

    private boolean isSafeSpot(Location location) {
        return location.getBlock().isEmpty() && location.clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && location.clone().add(0.0, -1.0, 0.0).getBlock().getType().isSolid();
    }

    private void glide(final Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 20, 49, true, false, false));
        new BukkitRunnable(){
            private boolean wasGliding = false;

            public void run() {
                if (player.isOnline() && !player.isDead() && player.getGameMode() != GameMode.SPECTATOR) {
                    if (!Abilities.this.isOnGround(player)) {
                        player.setGliding(true);
                        player.setFallDistance(0.0f);
                        this.wasGliding = true;
                    } else if (this.wasGliding && Abilities.this.isOnGround(player)) {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Glitch.getInstance(), 5L, 1L);
    }

    private boolean isOnGround(Player player) {
        return player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isSolid();
    }

    public void horse(final Player player) {
        SkeletonHorse skeletonHorse = (SkeletonHorse)player.getWorld().spawnEntity(player.getLocation(), EntityType.SKELETON_HORSE);
        skeletonHorse.setTamed(true);
        skeletonHorse.setOwner((AnimalTamer)player);
        skeletonHorse.setAdult();
        skeletonHorse.setCustomName(String.valueOf(ChatColor.GRAY) + "Steed");
        skeletonHorse.setCustomNameVisible(true);
        skeletonHorse.setPersistent(true);
        skeletonHorse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
        skeletonHorse.addPassenger((Entity)player);
        this.dismountCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + 1000L);
        new BukkitRunnable(){

            public void run() {
                Abilities.this.dismountCooldowns.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have summoned a Steed!");
    }

    @EventHandler
    public void onPlayerDismount(EntityDismountEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.dismountCooldowns.containsKey((player = (Player)event.getEntity()).getUniqueId())) {
            long remainingTime = this.dismountCooldowns.get(player.getUniqueId()) - System.currentTimeMillis();
            if (remainingTime > 0L) {
                event.setCancelled(true);
            } else {
                this.dismountCooldowns.remove(player.getUniqueId());
            }
        }
    }

    private void immune(final Player player) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 600, 254));
        player.playSound(player.getLocation(), Sound.ITEM_SHIELD_BLOCK, 1.0f, 1.0f);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now Immune for 30 seconds!");
        new BukkitRunnable(this){

            public void run() {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your Immunity has ended.");
            }
        }.runTaskLater((Plugin)this.plugin, 600L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        PotionEffect resistanceEffect;
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).hasPotionEffect(PotionEffectType.RESISTANCE) && (resistanceEffect = player.getPotionEffect(PotionEffectType.RESISTANCE)) != null && resistanceEffect.getAmplifier() == 254) {
            event.setCancelled(true);
        }
    }

    private void turnIntoHerobrine(final Player player) {
        final UUID playerId = player.getUniqueId();
        this.setHerobrineAppearance(player);
        this.addPlayerToHerobrineTeam(player);
        player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 400, 254, true, false));
        BukkitRunnable herobrineTimer = new BukkitRunnable(){

            public void run() {
                Abilities.this.resetPlayerAppearance(player);
                Abilities.this.removePlayerFromHerobrineTeam(player);
                herobrinePlayers.remove(playerId);
            }
        };
        herobrineTimer.runTaskLater((Plugin)Glitch.getInstance(), 400L);
        herobrinePlayers.put(playerId, herobrineTimer);
    }

    private void setHerobrineAppearance(Player player) {
        String var10001 = String.valueOf(ChatColor.DARK_RED);
        player.setDisplayName(var10001 + "Herobrine" + String.valueOf(ChatColor.RESET));
        var10001 = String.valueOf(ChatColor.DARK_RED);
        player.setPlayerListName(var10001 + "Herobrine" + String.valueOf(ChatColor.RESET));
        this.applyHerobrineSkin(player);
    }

    private void applyHerobrineSkin(Player player) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("skin set joey0919 " + player.getName()));
    }

    private void resetPlayerAppearance(Player player) {
        player.setDisplayName(player.getName());
        player.setPlayerListName(player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("skin clear " + player.getName()));
        this.removePlayerFromHerobrineTeam(player);
    }

    private void removePlayerFromHerobrineTeam(Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(HEROBRINE_TEAM);
        if (team != null) {
            team.removeEntry(player.getName());
        }
    }

    private void addPlayerToHerobrineTeam(Player player) {
        this.setupHerobrineTeam();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam(HEROBRINE_TEAM);
        if (team != null) {
            team.addEntry(player.getName());
        }
    }

    private void setupHerobrineTeam() {
        Scoreboard scoreboard;
        if (Bukkit.getScoreboardManager() != null && (scoreboard = Bukkit.getScoreboardManager().getMainScoreboard()).getTeam(HEROBRINE_TEAM) == null) {
            Team team = scoreboard.registerNewTeam(HEROBRINE_TEAM);
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            boolean isCritical;
            Player attacker = (Player)event.getDamager();
            UUID attackerId = attacker.getUniqueId();
            boolean bl = isCritical = !attacker.isOnGround() && attacker.getFallDistance() > 0.0f && !attacker.isSprinting();
            if (herobrinePlayers.containsKey(attackerId) && isCritical) {
                herobrineCritCount.put(attackerId, herobrineCritCount.getOrDefault(attackerId, 0) + 1);
                if (herobrineCritCount.get(attackerId) >= 3) {
                    Entity target = event.getEntity();
                    target.getWorld().strikeLightning(target.getLocation());
                    herobrineCritCount.put(attackerId, 0);
                }
            }
        }
    }

    private void prepareInventoryGlitch(final Player player) {
        this.pendingGlitchAttack.put(player.getUniqueId(), true);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your next attack will use the Inventory Glitch!");
        new BukkitRunnable(){

            public void run() {
                Abilities.this.pendingGlitchAttack.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 600L);
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            Player target = (Player)event.getEntity();
            if (this.pendingGlitchAttack.containsKey(attacker.getUniqueId())) {
                this.pendingGlitchAttack.remove(attacker.getUniqueId());
                this.applyInventoryGlitch(target);
                String var10001 = String.valueOf(ChatColor.GREEN);
                attacker.sendMessage(var10001 + "You have replaced an item in " + target.getName() + "'s inventory with dirt!");
            }
        }
    }

    private void applyInventoryGlitch(Player target) {
        int randomSlot;
        Random random = new Random();
        ItemStack[] inventoryContents = target.getInventory().getContents();
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (randomSlot = 0; randomSlot < 36; ++randomSlot) {
            if (inventoryContents[randomSlot] == null || inventoryContents[randomSlot].getType() == Material.AIR) continue;
            validSlots.add(randomSlot);
        }
        if (!validSlots.isEmpty()) {
            randomSlot = (Integer)validSlots.get(random.nextInt(validSlots.size()));
            target.getInventory().setItem(randomSlot, new ItemStack(Material.DIRT));
            target.sendMessage(String.valueOf(ChatColor.RED) + "One of your items has been replaced with dirt!");
        } else {
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your inventory is empty. No items were affected.");
        }
    }

    private void Invis(final Player player) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.equals((Object)player)) continue;
            onlinePlayer.hidePlayer((Plugin)Glitch.getInstance(), player);
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now fully invisible to other players for 30 seconds!");
        new BukkitRunnable(this){

            public void run() {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.showPlayer((Plugin)Glitch.getInstance(), player);
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are now visible to others again.");
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 600L);
    }

    private void item(Player player) {
        final World world = player.getWorld();
        this.weaponDamageDisabledUntil.put(world, System.currentTimeMillis() + 30000L);
        this.noDamageCaster.put(world, player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.RED) + "Disabled weapons for 30 seconds");
        new BukkitRunnable(){

            public void run() {
                if (Abilities.this.weaponDamageDisabledUntil.containsKey(world) && Abilities.this.weaponDamageDisabledUntil.get(world) < System.currentTimeMillis()) {
                    Abilities.this.weaponDamageDisabledUntil.remove(world);
                    Abilities.this.noDamageCaster.remove(world);
                    for (Player p : world.getPlayers()) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "Weapon damage is now restored!");
                    }
                }
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 600L);
    }

    @EventHandler
    public void onEntityDamageByEntity2(EntityDamageByEntityEvent event) {
        ItemStack itemInHand;
        Player playerDamager;
        World world;
        Entity damager = event.getDamager();
        if (damager instanceof Player && this.weaponDamageDisabledUntil.containsKey(world = (playerDamager = (Player)damager).getWorld()) && this.weaponDamageDisabledUntil.get(world) > System.currentTimeMillis() && (itemInHand = playerDamager.getInventory().getItemInMainHand()) != null && Arrays.asList(Material.DIAMOND_SWORD, Material.DIAMOND_AXE, Material.NETHERITE_SWORD, Material.NETHERITE_AXE, Material.IRON_SWORD, Material.IRON_AXE, Material.STONE_SWORD, Material.STONE_AXE, Material.WOODEN_SWORD, Material.WOODEN_AXE).contains(itemInHand.getType())) {
            if (this.noDamageCaster.containsKey(world) && this.noDamageCaster.get(world).equals(playerDamager.getUniqueId())) {
                return;
            }
            event.setDamage(1.0);
        }
    }

    private void Morph(final Player player) {
        this.pendingMorphAttack.put(player.getUniqueId(), true);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your next attack will morph you into the target!");
        new BukkitRunnable(){

            public void run() {
                Abilities.this.pendingMorphAttack.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, 600L);
    }

    @EventHandler
    public void onPlayerAttack2(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            Player target = (Player)event.getEntity();
            if (this.pendingMorphAttack.containsKey(attacker.getUniqueId())) {
                this.pendingMorphAttack.remove(attacker.getUniqueId());
                this.morphIntoPlayer(attacker, target);
                String var10001 = String.valueOf(ChatColor.GREEN);
                attacker.sendMessage(var10001 + "You have morphed into " + target.getName() + " for 60 seconds!");
            }
        }
    }

    private void morphIntoPlayer(final Player attacker, final Player target) {
        attacker.setDisplayName(target.getDisplayName());
        attacker.setPlayerListName(target.getPlayerListName());
        ConsoleCommandSender var10000 = Bukkit.getConsoleSender();
        String var10001 = target.getName();
        Bukkit.dispatchCommand((CommandSender)var10000, (String)("skin set " + var10001 + " " + attacker.getName()));
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team morphTeam = scoreboard.getTeam("morph_" + attacker.getName());
        if (morphTeam != null) {
            morphTeam.unregister();
        }
        morphTeam = scoreboard.registerNewTeam("morph_" + attacker.getName());
        morphTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        morphTeam.addEntry(attacker.getName());
        morphTeam.addEntry(target.getName());
        new BukkitRunnable(){

            public void run() {
                Abilities.this.resetPlayerAppearance(attacker, target);
            }
        }.runTaskLater((Plugin)this.plugin, 600L);
    }

    private void resetPlayerAppearance(Player attacker, Player target) {
        attacker.setDisplayName(attacker.getName());
        attacker.setPlayerListName(attacker.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("skin clear " + attacker.getName()));
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam("morph_" + attacker.getName());
        if (team != null) {
            team.removeEntry(attacker.getName());
            team.removeEntry(target.getName());
            team.unregister();
        }
        attacker.sendMessage(String.valueOf(ChatColor.RED) + "You have reverted to your original form.");
        target.sendMessage(String.valueOf(ChatColor.RED) + "Name tag visibility restored.");
    }

    public void effect(Player player) {
        boolean upgraded = false;
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (effect.getAmplifier() != 0) continue;
            PotionEffectType type = effect.getType();
            player.addPotionEffect(new PotionEffect(type, effect.getDuration(), 1, true, true));
            upgraded = true;
        }
        if (upgraded) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "All your T1 potions have been upgraded to T2");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no Tier 1 potions to upgrade!");
        }
    }

    private void virus(final Player player) {
        this.pendingVirusAttack.put(player.getUniqueId(), true);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your next attack will infect the target!");
        new BukkitRunnable(){

            public void run() {
                Abilities.this.pendingVirusAttack.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)Glitch.getInstance(), 600L);
    }

    @EventHandler
    public void onPlayerAttack3(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            Player target = (Player)event.getEntity();
            if (this.pendingVirusAttack.containsKey(attacker.getUniqueId())) {
                this.pendingVirusAttack.remove(attacker.getUniqueId());
                this.applyVirusEffect(target);
                String var10001 = String.valueOf(ChatColor.GREEN);
                attacker.sendMessage(var10001 + "You have infected " + target.getName() + " with a Virus!");
            }
        }
    }

    public void applyVirusEffect(Player target) {
        final UUID playerId = target.getUniqueId();
        if (!this.activeVirusEffects.contains(playerId)) {
            this.activeVirusEffects.add(playerId);
            this.actionBarUpdater.addPlayerWithActiveEffect(playerId);
            target.sendTitle("", "\ue005", 0, 200, 0);
            new BukkitRunnable(){

                public void run() {
                    Abilities.this.activeVirusEffects.remove(playerId);
                    Abilities.this.actionBarUpdater.removePlayerWithActiveEffect(playerId);
                }
            }.runTaskLater((Plugin)Glitch.getInstance(), 200L);
        }
    }

    private void tele(final Player player) {
        this.pendingTelekinesis.put(player.getUniqueId(), true);
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Your next attack will control the target for 10 seconds!");
        new BukkitRunnable(){

            public void run() {
                Abilities.this.pendingTelekinesis.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, 600L);
    }

    @EventHandler
    public void onPlayerAttack4(EntityDamageByEntityEvent event) {
        Entity target = event.getDamager();
        if (target instanceof Player) {
            Player attacker = (Player)target;
            target = event.getEntity();
            if (this.pendingTelekinesis.containsKey(attacker.getUniqueId())) {
                this.pendingTelekinesis.remove(attacker.getUniqueId());
                CooldownManager.setCooldown(attacker.getUniqueId(), "tele", COOLDOWNTELE);
                this.tele2(attacker, target);
            }
        }
    }

    private void tele2(final Player player, final Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 100, 1, true, false, false));
            this.controlledTargets.put(player.getUniqueId(), livingTarget);
            if (target instanceof Player) {
                Player var10000 = (Player)target;
                String var10001 = String.valueOf(ChatColor.RED);
                var10000.sendMessage(var10001 + "You are being controlled by " + player.getName() + "!");
            }
            new BukkitRunnable(){
                int ticks = 0;

                public void run() {
                    if (this.ticks < 100 && Abilities.this.controlledTargets.containsKey(player.getUniqueId())) {
                        Vector direction = player.getLocation().getDirection().normalize();
                        Location newLocation = player.getLocation().add(direction.multiply(3)).add(0.0, 0.0, 0.0);
                        target.teleport(newLocation);
                        ++this.ticks;
                    } else {
                        Abilities.this.endControl(target);
                        if (target instanceof Player) {
                            ((Player)target).sendMessage(String.valueOf(ChatColor.GREEN) + "You are no longer being controlled.");
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
    }

    private void endControl(Entity target) {
        if (this.controlledTargets.containsValue(target)) {
            this.controlledTargets.values().remove(target);
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You are free from telekinetic control.");
            }
            target.getWorld().playSound(target.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 0.7f);
        }
    }

    public void prepareSoul(Player player) {
        if (CooldownManager.isOnCooldown(player.getUniqueId(), "soul")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Soul ability is on cooldown!");
        } else if (CooldownManager.isOnCooldown(player.getUniqueId(), "charge")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You already prepared the ability");
        } else {
            CooldownManager.setCooldown(player.getUniqueId(), "charge", 5L);
            this.preparedSoul.add(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "Your next attack will split the player's soul.");
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.2f);
        }
    }

    @EventHandler
    public void onEntityDamageByPlayer2(EntityDamageByEntityEvent event) {
        Entity var3 = event.getDamager();
        if (var3 instanceof Player) {
            Player attacker = (Player)var3;
            Entity var4 = event.getEntity();
            if (var4 instanceof Player) {
                Player target = (Player)var4;
                if (this.preparedSoul.contains(attacker.getUniqueId())) {
                    this.preparedSoul.remove(attacker.getUniqueId());
                    CooldownManager.setCooldown(attacker.getUniqueId(), "soul", COOLDOWNSOUL);
                    ItemStack[] contents = target.getInventory().getContents();
                    ItemStack[] armor = target.getInventory().getArmorContents();
                    ItemStack offhand = target.getInventory().getItemInOffHand();
                    target.getInventory().clear();
                    target.getInventory().setArmorContents((ItemStack[])null);
                    target.getInventory().setItemInOffHand((ItemStack)null);
                    Zombie zombie = (Zombie)target.getWorld().spawn(target.getLocation(), Zombie.class);
                    zombie.setAI(false);
                    zombie.setSilent(true);
                    zombie.setCustomName(target.getName());
                    zombie.setCustomNameVisible(true);
                    zombie.setCanPickupItems(false);
                    zombie.setGlowing(true);
                    zombie.setAdult();
                    zombie.getEquipment().setArmorContents(armor);
                    zombie.getEquipment().setItemInOffHand(offhand);
                    double targetHealth = target.getHealth();
                    zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(targetHealth);
                    zombie.setHealth(targetHealth);
                    attacker.playSound(attacker.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
                    target.playSound(attacker.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
                    target.setAllowFlight(true);
                    target.setFlying(true);
                    target.setFlySpeed(0.05f);
                    target.setFallDistance(0.0f);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, Integer.MAX_VALUE, 254, false, false, false));
                    target.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, Integer.MAX_VALUE, 0, false, false, false));
                    target.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
                    Vector direction = attacker.getLocation().getDirection().normalize().multiply(-2.5).setY(1.5);
                    target.setVelocity(direction);
                    this.storedInventories.put(zombie.getUniqueId(), new StoredData(target.getUniqueId(), contents, armor, offhand));
                    event.setCancelled(true);
                } else if (this.hasMaxFatigue(attacker) || this.hasMaxFatigue(target)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onZombieRightClick(PlayerInteractAtEntityEvent event) {
        Zombie zombie;
        UUID zombieId;
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity instanceof Zombie && this.storedInventories.containsKey(zombieId = (zombie = (Zombie)entity).getUniqueId())) {
            StoredData data = this.storedInventories.get(zombieId);
            if (data.playerUUID.equals(player.getUniqueId())) {
                player.getInventory().setContents(data.contents);
                player.getInventory().setArmorContents(data.armor);
                player.getInventory().setItemInOffHand(data.offhand);
                Iterator var7 = player.getActivePotionEffects().iterator();
                while (true) {
                    if (!var7.hasNext()) {
                        player.setFlying(false);
                        player.setAllowFlight(false);
                        player.setFlySpeed(0.1f);
                        Location loc = zombie.getLocation();
                        loc.setDirection(zombie.getLocation().getDirection());
                        player.teleport(loc);
                        double zombieHealth = zombie.getHealth();
                        double playerMaxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                        player.setHealth(Math.min(zombieHealth, playerMaxHealth));
                        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                        player.swingMainHand();
                        zombie.remove();
                        this.storedInventories.remove(zombieId);
                        return;
                    }
                    PotionEffect effect = (PotionEffect)var7.next();
                    PotionEffectType type = effect.getType();
                    if (type != PotionEffectType.MINING_FATIGUE && type != PotionEffectType.DARKNESS && type != PotionEffectType.GLOWING && type != PotionEffectType.INVISIBILITY) continue;
                    player.removePotionEffect(type);
                }
            }
        }
    }

    @EventHandler
    public void onZombieDeath(EntityDeathEvent event) {
        Zombie zombie;
        UUID zombieId;
        LivingEntity var3 = event.getEntity();
        if (var3 instanceof Zombie && this.storedInventories.containsKey(zombieId = (zombie = (Zombie)var3).getUniqueId())) {
            StoredData data = this.storedInventories.get(zombieId);
            Player target = Bukkit.getPlayer((UUID)data.playerUUID);
            if (target != null) {
                target.teleport(zombie.getLocation());
                target.getInventory().setContents(data.contents);
                target.getInventory().setArmorContents(data.armor);
                target.getInventory().setItemInOffHand(data.offhand);
                target.setFlying(false);
                target.setAllowFlight(false);
                target.setFlySpeed(0.1f);
                Iterator var6 = target.getActivePotionEffects().iterator();
                while (true) {
                    if (!var6.hasNext()) {
                        target.setHealth(0.0);
                        break;
                    }
                    PotionEffect effect = (PotionEffect)var6.next();
                    PotionEffectType type = effect.getType();
                    if (type != PotionEffectType.MINING_FATIGUE && type != PotionEffectType.DARKNESS && type != PotionEffectType.GLOWING && type != PotionEffectType.INVISIBILITY) continue;
                    target.removePotionEffect(type);
                }
            }
            this.storedInventories.remove(zombieId);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.hasMaxFatigue(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void damage(EntityDamageEvent event) {
        Player player;
        Entity var3 = event.getEntity();
        if (var3 instanceof Player && this.hasMaxFatigue(player = (Player)var3)) {
            event.setCancelled(true);
        }
    }

    private boolean hasMaxFatigue(Player player) {
        ItemStack offHand;
        PotionEffect effect = player.getPotionEffect(PotionEffectType.MINING_FATIGUE);
        boolean hasMaxFatigue = effect != null && effect.getAmplifier() >= 254;
        boolean hasNoItems = true;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            hasNoItems = false;
            break;
        }
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            hasNoItems = false;
            break;
        }
        if ((offHand = player.getInventory().getItemInOffHand()) != null && offHand.getType() != Material.AIR) {
            hasNoItems = false;
        }
        return hasMaxFatigue && hasNoItems;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.hasMaxFatigue(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity var3 = event.getWhoClicked();
        if (var3 instanceof Player && this.hasMaxFatigue(player = (Player)var3)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent event) {
        Player player;
        LivingEntity var3 = event.getEntity();
        if (var3 instanceof Player && this.hasMaxFatigue(player = (Player)var3)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
            player.setAllowFlight(false);
            player.setFlying(false);
        }, 10L);
    }

    public void diffuse(Player player) {
        World playerWorld = player.getWorld();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getWorld().equals((Object)playerWorld)) continue;
            if (!online.getUniqueId().equals(player.getUniqueId())) {
                CooldownManager.setCooldown(online.getUniqueId(), "diffused", 30L);
            }
            online.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
        }
        String message = String.valueOf(ChatColor.RED) + "All glitches have been diffused for 30 seconds";
        for (Player online : playerWorld.getPlayers()) {
            online.sendMessage(message);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
            String returnMessage = String.valueOf(ChatColor.LIGHT_PURPLE) + "Glitches have been enabled again";
            for (Player online : playerWorld.getPlayers()) {
                online.sendMessage(returnMessage);
            }
        }, 600L);
    }

    public void redstone(Player player) {
        this.isRedstoneDisabled = true;
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getUniqueId().equals(player.getUniqueId())) {
                CooldownManager.setCooldown(online.getUniqueId(), "diffused", 30L);
            }
            online.playSound(player.getLocation(), Sound.BLOCK_PISTON_EXTEND, 1.0f, 1.0f);
        }
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.LIGHT_PURPLE) + "Redstone has been disabled for 30 seconds"));
        Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
            this.isRedstoneDisabled = false;
            this.redstoneBlocked.clear();
            for (Player online1 : Bukkit.getOnlinePlayers()) {
                online1.playSound(online1.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 1.0f, 1.0f);
            }
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.RED) + "Redstone has been enabled again"));
        }, 600L);
    }

    public void crasher(Player player) {
        this.crasherReady.add(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.RED) + "Your next hit will crash the target!");
    }

    @EventHandler
    public void onCrasherHit(EntityDamageByEntityEvent event) {
        Entity var3 = event.getDamager();
        if (var3 instanceof Player) {
            Player attacker = (Player)var3;
            Entity var4 = event.getEntity();
            if (var4 instanceof Player) {
                Player victim = (Player)var4;
                if (this.crasherReady.contains(attacker.getUniqueId())) {
                    this.crasherReady.remove(attacker.getUniqueId());
                    this.blockedRejoin.put(victim.getUniqueId(), System.currentTimeMillis() + 15000L);
                    victim.kickPlayer("Connection Lost\n");
                    String var10001 = String.valueOf(ChatColor.DARK_RED);
                    attacker.sendMessage(var10001 + "You crashed " + victim.getName());
                    CooldownManager.setCooldown(attacker.getUniqueId(), "crasher", COOLDOWNCRASHER);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.blockedRejoin.containsKey(uuid)) {
            long until = this.blockedRejoin.get(uuid);
            if (System.currentTimeMillis() < until) {
                long secondsLeft = (until - System.currentTimeMillis()) / 1000L;
                PlayerLoginEvent.Result var10001 = PlayerLoginEvent.Result.KICK_OTHER;
                String var10002 = String.valueOf(ChatColor.RED);
                event.disallow(var10001, var10002 + "Connection Lost\n Wait " + secondsLeft + "s.");
                return;
            }
            this.blockedRejoin.remove(uuid);
        }
    }

    public void dash(final Player player) {
        UUID playerUUID = player.getUniqueId();
        Vector direction = player.getEyeLocation().getDirection().normalize();
        Vector dashVector = direction.clone().multiply(2);
        player.setVelocity(dashVector);
        new BukkitRunnable(this){
            final int maxTicks = 20;
            int ticksPassed = 0;
            Location previousLocation = player.getLocation();

            public void run() {
                if (this.ticksPassed < 20 && player.isOnline()) {
                    Location currentLocation = player.getLocation();
                    double distance = this.previousLocation.distance(currentLocation);
                    if (distance > 0.1) {
                        Vector step = currentLocation.toVector().subtract(this.previousLocation.toVector()).normalize().multiply(0.3);
                        Location particleLocation = this.previousLocation.clone();
                        this.previousLocation = currentLocation.clone();
                    }
                    ++this.ticksPassed;
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void dupe(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null && !item.getType().isAir()) {
            Material type = item.getType();
            if (type != Material.CLAY_BALL && type != Material.DRAGON_EGG && type != Material.LEATHER_CHESTPLATE && type != Material.MACE && !type.name().contains("SHULKER_BOX")) {
                CooldownManager.setCooldown(player.getUniqueId(), "dupe", COOLDOWNDUPE);
                int baseMaxStack = item.getMaxStackSize();
                int treatedMaxStack = baseMaxStack == 1 ? 2 : baseMaxStack;
                int currentAmount = item.getAmount();
                if (currentAmount < treatedMaxStack) {
                    item.setAmount(currentAmount + 1);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Duped 1 item");
                } else {
                    ItemStack drop = item.clone();
                    drop.setAmount(1);
                    player.getWorld().dropItemNaturally(player.getLocation(), drop);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Stack is full. Dropped a duped item.");
                }
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item cannot be duped.");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You're not holding an item to dupe.");
        }
    }

    private void raycast(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.5f, 1.0f);
        double startDistance = 2.0;
        double radius = 7.0;
        double step = 1.0;
        Vector direction = player.getLocation().getDirection().normalize();
        Location start = player.getLocation().add(0.0, 1.5, 0.0).add(direction.clone().multiply(startDistance));
        for (double i = 0.0; i <= radius - startDistance; i += step) {
            Location particleLocation = start.clone().add(direction.clone().multiply(i));
            Particle.DustOptions magentaDust = new Particle.DustOptions(Color.fromRGB((int)255, (int)0, (int)255), 1.2f);
            player.getWorld().spawnParticle(Particle.END_ROD, particleLocation, 8, 0.3, 0.3, 0.3, 0.0);
            player.getWorld().spawnParticle(Particle.DUST, particleLocation, 8, 0.3, 0.3, 0.3, 0.0, (Object)magentaDust);
            for (Entity entity : player.getWorld().getNearbyEntities(particleLocation, 0.4, 0.9, 0.4)) {
                if (!(entity instanceof LivingEntity) || entity.equals((Object)player)) continue;
                ((LivingEntity)entity).damage(30.0, (Entity)player);
                entity.setVelocity(direction.clone().multiply(0.5));
            }
        }
    }

    public void shulker(Player player) {
        String path;
        Inventory inv = Bukkit.createInventory((InventoryHolder)null, (int)27, (String)(String.valueOf(ChatColor.LIGHT_PURPLE) + "Shulker Storage"));
        File file = new File(Glitch.getInstance().getDataFolder(), "items.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (config.contains(path = "storage." + String.valueOf(player.getUniqueId()))) {
            List items = (List)config.get(path);
            for (int i = 0; i < Math.min(items.size(), 27); ++i) {
                inv.setItem(i, (ItemStack)items.get(i));
            }
        }
        player.openInventory(inv);
        this.openShulkerMenus.put(player.getUniqueId(), inv);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.openShulkerMenus.containsKey(uuid)) {
            Inventory inv = event.getInventory();
            ArrayList<ItemStack> contents = new ArrayList<ItemStack>(Arrays.asList(inv.getContents()));
            File file = new File(Glitch.getInstance().getDataFolder(), "items.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            config.set("storage." + String.valueOf(uuid), contents);
            try {
                config.save(file);
            }
            catch (IOException var9) {
                IOException e = var9;
                e.printStackTrace();
            }
            this.openShulkerMenus.remove(uuid);
        }
    }

    public void Inven(Player player) {
        this.invenActive.add(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "Your next attack will scramble your enemy's inventory!");
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Entity var3 = event.getDamager();
        if (var3 instanceof Player) {
            Player damager = (Player)var3;
            Entity var4 = event.getEntity();
            if (var4 instanceof Player) {
                Player target = (Player)var4;
                UUID damagerUUID = damager.getUniqueId();
                if (this.invenActive.contains(damagerUUID)) {
                    this.invenActive.remove(damagerUUID);
                    this.scrambleInventory(target);
                    String var10001 = String.valueOf(ChatColor.LIGHT_PURPLE);
                    damager.sendMessage(var10001 + "You scrambled " + target.getName() + "'s inventory!");
                    target.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory has been scrambled!");
                }
            }
        }
    }

    private void scrambleInventory(Player target) {
        int i;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = 0; i < 36; ++i) {
            items.add(target.getInventory().getItem(i));
        }
        Collections.shuffle(items);
        for (i = 0; i < 36; ++i) {
            target.getInventory().setItem(i, (ItemStack)items.get(i));
        }
        target.updateInventory();
    }

    private static class StoredData {
        UUID playerUUID;
        ItemStack[] contents;
        ItemStack[] armor;
        ItemStack offhand;

        public StoredData(UUID playerUUID, ItemStack[] contents, ItemStack[] armor, ItemStack offhand) {
            this.playerUUID = playerUUID;
            this.contents = contents;
            this.armor = armor;
            this.offhand = offhand;
        }
    }
}

