/*
 * Decompiled with CFR 0.152.
 */
package hs;

import hs.GlitchesManger;
import hs.IMP.Abilities;
import hs.IMP.AbilityMenuListener;
import hs.IMP.ActionBarUpdater;
import hs.IMP.HackEquipListener;
import hs.IMP.SwordBringer;
import hs.IMP.UnequipCommand;
import hs.Managers.ArmorAndItemEffectsListener;
import hs.Managers.CooldownCommand;
import hs.Managers.CooldownManager;
import hs.Managers.NameColorUpdater;
import hs.Managers.PlayerHackManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Glitch
extends JavaPlugin
implements Listener,
TabCompleter {
    private static Glitch instance;
    private final ConcurrentMap<UUID, String> hackManager = new ConcurrentHashMap<UUID, String>();
    private PlayerHackManager hackManager2;
    private GlitchesManger glitchesManger;
    private static long COOLDOWNMACE;
    public Abilities abilitiesHandler;

    public static long getCooldownMace() {
        return COOLDOWNMACE;
    }

    public static Glitch getInstance() {
        return instance;
    }

    public void onEnable() {
        this.glitchesManger = new GlitchesManger((Plugin)this);
        if (!this.glitchesManger.isLicensed()) {
            Bukkit.getLogger().warning("[License] Plugin disabled due to invalid license. Contact the dev of the plugin");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            if (instance != null) {
                throw new IllegalStateException("Plugin already initialized!");
            }
            instance = this;
            this.saveDefaultConfig();
            COOLDOWNMACE = this.getConfig().getLong("cooldowns.Mace");
            this.hackManager2 = new PlayerHackManager();
            this.registerCommands();
            this.registerEvents();
            new ActionBarUpdater().runTaskTimer((Plugin)this, 0L, 20L);
            this.getLogger().info("Glitch SMP Plugin has been enabled!");
        }
    }

    private void registerCommands() {
        this.getCommand("cooldown").setExecutor((CommandExecutor)new CooldownCommand());
        this.getCommand("controls").setExecutor(new CommandExecutor(){

            public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
                    return true;
                }
                Player player = (Player)sender;
                String permission = "offhand";
                if (player.hasPermission(permission)) {
                    player.addAttachment((Plugin)Glitch.this, permission, false);
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "Turned on Command to use ability");
                } else {
                    player.addAttachment((Plugin)Glitch.this, permission, true);
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "Turned on Offhand to use ability");
                }
                return true;
            }
        });
        this.getCommand("clearglitch").setExecutor(new CommandExecutor(){

            public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
                if (args.length != 1) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /clearglitch <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target != null && target.isOnline()) {
                    Glitch.this.hackManager2.removeHack(target.getUniqueId(), "1");
                    Glitch.this.hackManager2.removeHack(target.getUniqueId(), "2");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found or not online.");
                return true;
            }
        });
    }

    public void onDisable() {
        instance = null;
        this.getLogger().info("Glitch SMP Plugin is disabling...");
        for (UUID uuid : this.hackManager.keySet()) {
            this.hackManager.remove(uuid);
        }
        this.getLogger().info("Glitch SMP Plugin has been disabled!");
    }

    public static ItemStack createRerollItem() {
        ItemStack rerollItem = new ItemStack(Material.NETHER_STAR);
        ItemMeta meta = rerollItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Choose your Glitch");
            meta.setLore(List.of(String.valueOf(ChatColor.GREEN) + "Right-click to choose your hacks!"));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            rerollItem.setItemMeta(meta);
        }
        return rerollItem;
    }

    private void registerEvents() {
        this.abilitiesHandler = new Abilities(this);
        this.getCommand("swap").setExecutor((CommandExecutor)new HackEquipListener());
        this.getCommand("withdraw").setExecutor((CommandExecutor)new UnequipCommand((Plugin)this));
        this.getCommand("withdraw").setTabCompleter(new TabCompleter(this){

            public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
                return args.length == 1 ? Arrays.asList("1", "2") : Collections.emptyList();
            }
        });
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SwordBringer(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HackEquipListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ArmorAndItemEffectsListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AbilityMenuListener(this.hackManager2), (Plugin)this);
        new NameColorUpdater(this).start();
        Bukkit.getPluginManager().registerEvents((Listener)this.abilitiesHandler, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GlitchesManger((Plugin)this), (Plugin)this);
        this.getCommand("ability1").setExecutor((CommandExecutor)this.abilitiesHandler);
        this.getCommand("ability2").setExecutor((CommandExecutor)this.abilitiesHandler);
        this.getCommand("ability3").setExecutor((CommandExecutor)this.abilitiesHandler);
    }

    @EventHandler
    public void onRightClickWithMace(PlayerInteractEvent event) {
        if (!event.getPlayer().hasCooldown(Material.MACE) && event.getAction().toString().contains("RIGHT_CLICK")) {
            ItemMeta meta;
            Player player = event.getPlayer();
            ItemStack item = event.getItem();
            if (item != null && item.getType() == Material.MACE && item.hasItemMeta() && (meta = item.getItemMeta()).hasCustomModelData() && meta.getCustomModelData() == 1) {
                int ticks = (int)(Glitch.getCooldownMace() * 20L);
                player.setCooldown(Material.MACE, ticks);
                this.diffuse(player);
            }
        }
    }

    public void diffuse(Player player) {
        World casterWorld = player.getWorld();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getWorld().equals((Object)casterWorld)) continue;
            if (!online.getUniqueId().equals(player.getUniqueId())) {
                CooldownManager.setCooldown(online.getUniqueId(), "diffused", 60L);
            }
            online.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.0f);
        }
        for (Player online : casterWorld.getPlayers()) {
            online.sendMessage(String.valueOf(ChatColor.RED) + "All glitches have been diffused for 1 minute");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Glitch.getInstance(), () -> {
            for (Player p : casterWorld.getPlayers()) {
                p.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + "Glitches have been enabled again");
            }
        }, 1200L);
    }
}

